/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNRecordsQuery
implements ITopNRecordsQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopNRecordsQuery.class);
    private final InfluxClient client;
    private static final Comparator<SelectedRecord> ASCENDING = Comparator.comparingLong(a -> ((Number)Double.parseDouble(a.getValue())).longValue());
    private static final Comparator<SelectedRecord> DESCENDING = (a, b) -> Long.compare(((Number)Double.parseDouble(b.getValue())).longValue(), ((Number)Double.parseDouble(a.getValue())).longValue());

    public TopNRecordsQuery(InfluxClient client) {
        this.client = client;
    }

    public List<SelectedRecord> readSampledRecords(TopNCondition condition, String valueColumnName, Duration duration) throws IOException {
        String function = "bottom";
        Comparator<SelectedRecord> comparator = ASCENDING;
        if (condition.getOrder().equals((Object)Order.DES)) {
            function = "top";
            comparator = DESCENDING;
        }
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).function(function, new Object[]{valueColumnName, condition.getTopN()}).column("statement").column("trace_id").from(this.client.getDatabase(), condition.getName()).where();
        query.and(BuiltQuery.QueryBuilder.gte((String)"time_bucket", (Object)duration.getStartTimeBucketInSec())).and(BuiltQuery.QueryBuilder.lte((String)"time_bucket", (Object)duration.getEndTimeBucketInSec()));
        if (StringUtil.isNotEmpty((String)condition.getParentService())) {
            String serviceId = IDManager.ServiceID.buildId((String)condition.getParentService(), (boolean)condition.isNormal());
            query.and(BuiltQuery.QueryBuilder.eq((String)"_service_id", (Object)serviceId));
        }
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), (Object)series);
        }
        if (series == null) {
            return Collections.emptyList();
        }
        ArrayList<SelectedRecord> records = new ArrayList<SelectedRecord>();
        series.getValues().forEach(values -> {
            SelectedRecord record = new SelectedRecord();
            record.setValue(String.valueOf(values.get(1)));
            record.setRefId((String)values.get(3));
            record.setId(record.getRefId());
            record.setName((String)values.get(2));
            records.add(record);
        });
        records.sort(comparator);
        return records;
    }
}

