/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.influxdb.query;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.IntValues;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.influxdb.InfluxClient;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.querybuilder.BuiltQuery;
import org.influxdb.querybuilder.SelectionQueryImpl;
import org.influxdb.querybuilder.WhereQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsQuery
implements IMetricsQueryDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsQuery.class);
    private final InfluxClient client;

    public MetricsQuery(InfluxClient client) {
        this.client = client;
    }

    public long readMetricsValue(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        Iterator<QueryResult.Series> iterator;
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        Function function = ValueColumnMetadata.INSTANCE.getValueFunction(condition.getName());
        if (function == Function.Latest) {
            return this.readMetricsValues(condition, valueColumnName, duration).getValues().latestValue(defaultValue);
        }
        String measurement = condition.getName();
        SelectionQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]);
        if (function == Function.Avg) {
            query.mean((Object)valueColumnName);
        } else {
            query.sum((Object)valueColumnName);
        }
        WhereQueryImpl queryWhereQuery = query.from(this.client.getDatabase(), measurement).where();
        String entityId = condition.getEntity().buildId();
        if (entityId != null) {
            queryWhereQuery.and(BuiltQuery.QueryBuilder.eq((String)"_entity_id", (Object)entityId));
        }
        queryWhereQuery.and(BuiltQuery.QueryBuilder.gte((String)"time", (Object)InfluxClient.timeIntervalTS(duration.getStartTimestamp()))).and(BuiltQuery.QueryBuilder.lte((String)"time", (Object)InfluxClient.timeIntervalTS(duration.getEndTimestamp()))).groupBy(new Object[]{"_entity_id"});
        List<QueryResult.Series> seriesList = this.client.queryForSeries((Query)queryWhereQuery);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)queryWhereQuery.getCommand(), seriesList);
        }
        if (CollectionUtils.isNotEmpty(seriesList) && (iterator = seriesList.iterator()).hasNext()) {
            QueryResult.Series series = iterator.next();
            Number value = (Number)((List)series.getValues().get(0)).get(1);
            return value.longValue();
        }
        return defaultValue;
    }

    public MetricsValues readMetricsValues(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        List pointOfTimes = duration.assembleDurationPoints();
        ArrayList ids = new ArrayList(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> ids.add(pointOfTime.id(condition.getEntity().buildId())));
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("id").column(valueColumnName).from(this.client.getDatabase(), condition.getName()).where();
        if (CollectionUtils.isNotEmpty(ids)) {
            if (ids.size() == 1) {
                query.where(BuiltQuery.QueryBuilder.eq((String)"id", ids.get(0)));
            } else {
                query.where(BuiltQuery.QueryBuilder.contains((String)"id", (String)Joiner.on((String)"|").join(ids)));
            }
        }
        List<QueryResult.Series> seriesList = this.client.queryForSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), seriesList);
        }
        MetricsValues metricsValues = new MetricsValues();
        IntValues intValues = metricsValues.getValues();
        if (CollectionUtils.isNotEmpty(seriesList)) {
            seriesList.get(0).getValues().forEach(values -> {
                KVInt kv = new KVInt();
                kv.setValue(((Number)values.get(2)).longValue());
                kv.setId((String)values.get(1));
                intValues.addKVInt(kv);
            });
        }
        metricsValues.setValues(IMetricsQueryDAO.Util.sortValues((IntValues)intValues, ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName())));
        return metricsValues;
    }

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition condition, String valueColumnName, List<String> labels, Duration duration) throws IOException {
        List pointOfTimes = duration.assembleDurationPoints();
        ArrayList ids = new ArrayList(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> ids.add(pointOfTime.id(condition.getEntity().buildId())));
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("id").column(valueColumnName).from(this.client.getDatabase(), condition.getName()).where();
        if (CollectionUtils.isNotEmpty(ids)) {
            if (ids.size() == 1) {
                query.where(BuiltQuery.QueryBuilder.eq((String)"id", ids.get(0)));
            } else {
                query.where(BuiltQuery.QueryBuilder.contains((String)"id", (String)Joiner.on((String)"|").join(ids)));
            }
        }
        List<QueryResult.Series> series = this.client.queryForSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), series);
        }
        HashMap idMap = new HashMap();
        if (!CollectionUtils.isEmpty(series)) {
            series.get(0).getValues().forEach(values -> {
                String id = (String)values.get(1);
                DataTable multipleValues = new DataTable(5);
                multipleValues.toObject((String)values.get(2));
                idMap.put(id, multipleValues);
            });
        }
        return IMetricsQueryDAO.Util.composeLabelValue((MetricsCondition)condition, labels, ids, idMap);
    }

    public HeatMap readHeatMap(MetricsCondition condition, String valueColumnName, Duration duration) throws IOException {
        List pointOfTimes = duration.assembleDurationPoints();
        ArrayList ids = new ArrayList(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> ids.add(pointOfTime.id(condition.getEntity().buildId())));
        WhereQueryImpl query = BuiltQuery.QueryBuilder.select((String[])new String[0]).column("id").column(valueColumnName).from(this.client.getDatabase(), condition.getName()).where(BuiltQuery.QueryBuilder.contains((String)"id", (String)Joiner.on((String)"|").join(ids)));
        QueryResult.Series series = this.client.queryForSingleSeries((Query)query);
        if (log.isDebugEnabled()) {
            log.debug("SQL: {} result set: {}", (Object)query.getCommand(), (Object)series);
        }
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        HeatMap heatMap = new HeatMap();
        if (series != null) {
            for (List values : series.getValues()) {
                heatMap.buildColumn(values.get(1).toString(), values.get(2).toString(), defaultValue);
            }
        }
        heatMap.fixMissingColumns(ids, defaultValue);
        return heatMap;
    }
}

