/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.management.v3.InstancePingPkg;
import org.apache.skywalking.apm.network.management.v3.InstanceProperties;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.module.KafkaFetcherConfig;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.AbstractKafkaHandler;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.NodeType;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceUpdate;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManagementHandler
extends AbstractKafkaHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceManagementHandler.class);
    private final SourceReceiver sourceReceiver;
    private final NamingControl namingLengthControl;

    public ServiceManagementHandler(ModuleManager moduleManager, KafkaFetcherConfig config) {
        super(moduleManager, config);
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.namingLengthControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        this.config = config;
    }

    @Override
    public void handle(ConsumerRecord<String, Bytes> record) {
        try {
            if (((String)record.key()).startsWith("register-")) {
                this.serviceReportProperties(InstanceProperties.parseFrom((byte[])((Bytes)record.value()).get()));
            } else {
                this.keepAlive(InstancePingPkg.parseFrom((byte[])((Bytes)record.value()).get()));
            }
        }
        catch (Exception e) {
            log.error("handle record failed", (Throwable)e);
        }
    }

    private final void serviceReportProperties(InstanceProperties request) {
        ServiceInstanceUpdate serviceInstanceUpdate = new ServiceInstanceUpdate();
        String serviceName = this.namingLengthControl.formatServiceName(request.getService());
        String instanceName = this.namingLengthControl.formatInstanceName(request.getServiceInstance());
        serviceInstanceUpdate.setServiceId(IDManager.ServiceID.buildId((String)serviceName, (NodeType)NodeType.Normal));
        serviceInstanceUpdate.setName(instanceName);
        if (log.isDebugEnabled()) {
            log.debug("Service[{}] instance[{}] registered.", (Object)serviceName, (Object)instanceName);
        }
        JsonObject properties = new JsonObject();
        ArrayList ipv4List = new ArrayList();
        request.getPropertiesList().forEach(prop -> {
            if ("ipv4".equals(prop.getKey())) {
                ipv4List.add(prop.getValue());
            } else {
                properties.addProperty(prop.getKey(), prop.getValue());
            }
        });
        properties.addProperty("ipv4s", ipv4List.stream().collect(Collectors.joining(",")));
        serviceInstanceUpdate.setProperties(properties);
        serviceInstanceUpdate.setTimeBucket(TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute));
        this.sourceReceiver.receive((ISource)serviceInstanceUpdate);
    }

    private final void keepAlive(InstancePingPkg request) {
        long timeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute);
        String serviceName = this.namingLengthControl.formatServiceName(request.getService());
        String instanceName = this.namingLengthControl.formatInstanceName(request.getServiceInstance());
        if (log.isDebugEnabled()) {
            log.debug("A ping of Service[{}] instance[{}].", (Object)serviceName, (Object)instanceName);
        }
        ServiceInstanceUpdate serviceInstanceUpdate = new ServiceInstanceUpdate();
        serviceInstanceUpdate.setServiceId(IDManager.ServiceID.buildId((String)serviceName, (NodeType)NodeType.Normal));
        serviceInstanceUpdate.setName(instanceName);
        serviceInstanceUpdate.setTimeBucket(timeBucket);
        this.sourceReceiver.receive((ISource)serviceInstanceUpdate);
    }

    @Override
    protected String getPlainTopic() {
        return this.config.getTopicNameOfManagements();
    }
}

