/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler;

import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.language.agent.v3.MeterDataCollection;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.module.KafkaFetcherConfig;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.AbstractKafkaHandler;
import org.apache.skywalking.oap.server.analyzer.provider.meter.process.IMeterProcessService;
import org.apache.skywalking.oap.server.analyzer.provider.meter.process.MeterProcessor;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeterServiceHandler
extends AbstractKafkaHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeterServiceHandler.class);
    private final IMeterProcessService processService;
    private final HistogramMetrics histogram;
    private final HistogramMetrics histogramBatch;
    private final CounterMetrics errorCounter;

    public MeterServiceHandler(ModuleManager manager, KafkaFetcherConfig config) {
        super(manager, config);
        this.processService = (IMeterProcessService)manager.find("agent-analyzer").provider().getService(IMeterProcessService.class);
        MetricsCreator metricsCreator = (MetricsCreator)manager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("meter_in_latency", "The process latency of meter", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}), new double[0]);
        this.histogramBatch = metricsCreator.createHistogramMetric("meter_batch_in_latency", "The process latency of meter", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("meter_analysis_error_count", "The error number of meter analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}));
    }

    @Override
    public void handle(ConsumerRecord<String, Bytes> record) {
        try (HistogramMetrics.Timer timer = this.histogramBatch.createTimer();){
            MeterDataCollection meterDataCollection = MeterDataCollection.parseFrom((byte[])((Bytes)record.value()).get());
            MeterProcessor processor = this.processService.createProcessor();
            meterDataCollection.getMeterDataList().forEach(meterData -> {
                try (HistogramMetrics.Timer ignored = this.histogram.createTimer();){
                    processor.read(meterData);
                }
                catch (Exception e) {
                    this.errorCounter.inc();
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
            processor.process();
        }
        catch (Exception e) {
            log.error("handle record failed", (Throwable)e);
        }
    }

    @Override
    protected String getPlainTopic() {
        return this.config.getTopicNameOfMeters();
    }
}

