/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler;

import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.oap.log.analyzer.provider.log.ILogAnalyzerService;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.module.KafkaFetcherConfig;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.KafkaHandler;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHandler
implements KafkaHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogHandler.class);
    private final KafkaFetcherConfig config;
    private final HistogramMetrics histogram;
    private final CounterMetrics errorCounter;
    private final ILogAnalyzerService logAnalyzerService;

    public LogHandler(ModuleManager moduleManager, KafkaFetcherConfig config) {
        this.config = config;
        this.logAnalyzerService = (ILogAnalyzerService)moduleManager.find("log-analyzer").provider().getService(ILogAnalyzerService.class);
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("log_in_latency", "The process latency of log", new MetricsTag.Keys(new String[]{"protocol", "data_format"}), new MetricsTag.Values(new String[]{"kafka", this.getDataFormat()}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("log_analysis_error_count", "The error number of log analysis", new MetricsTag.Keys(new String[]{"protocol", "data_format"}), new MetricsTag.Values(new String[]{"kafka", this.getDataFormat()}));
    }

    @Override
    public String getConsumePartitions() {
        return this.config.getConsumePartitions();
    }

    @Override
    public String getTopic() {
        return this.config.getTopicNameOfLogs();
    }

    @Override
    public void handle(ConsumerRecord<String, Bytes> record) {
        try (HistogramMetrics.Timer ignore = this.histogram.createTimer();){
            LogData logData = this.parseConsumerRecord(record);
            this.logAnalyzerService.doAnalysis(logData, null);
        }
        catch (Exception e) {
            this.errorCounter.inc();
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected String getDataFormat() {
        return "protobuf";
    }

    protected LogData parseConsumerRecord(ConsumerRecord<String, Bytes> record) throws Exception {
        return LogData.parseFrom((byte[])((Bytes)record.value()).get());
    }
}

