/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.util.StringUtil;

public interface KafkaHandler {
    default public List<TopicPartition> getTopicPartitions() {
        if (StringUtil.isEmpty((String)this.getConsumePartitions())) {
            return Collections.EMPTY_LIST;
        }
        ArrayList topicPartitions = Lists.newArrayList();
        for (String partition : this.getConsumePartitions().trim().split("\\s*,\\s*")) {
            topicPartitions.add(new TopicPartition(this.getTopic(), Integer.parseInt(partition)));
        }
        return topicPartitions;
    }

    public String getConsumePartitions();

    public String getTopic();

    public void handle(ConsumerRecord<String, Bytes> var1);
}

