/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.registry.api.path.InstancePathConstants;
import org.apache.shenyu.registry.apollo.ApolloClient;
import org.apache.shenyu.registry.apollo.ApolloConfig;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ApolloInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final String APOLLO_CLUSTER = "apollo.cluster";
    private static final String PROP_APP_ID = "app.id";
    private static final String PROP_APOLLO_META = "apollo.meta";
    private static final String APOLLO_NAMESPACE = "apollo.bootstrap.namespace";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApolloInstanceRegisterRepository.class);
    private ApolloClient apolloClient;
    private final Map<String, ConfigChangeListener> configChangeListenerMap = Maps.newConcurrentMap();
    private final Map<String, List<InstanceEntity>> watcherInstanceRegisterMap = new HashMap<String, List<InstanceEntity>>();
    private String namespace;
    private Config configService;

    public void init(RegisterConfig config) {
        Properties properties = config.getProps();
        String meta = config.getServerLists();
        String appId = properties.getProperty("appId", "shenyu");
        String clusterName = properties.getProperty("clusterName", "default");
        String namespace = properties.getProperty("namespace", "application");
        Optional.ofNullable(appId).ifPresent(x -> System.setProperty(PROP_APP_ID, x));
        Optional.ofNullable(meta).ifPresent(x -> System.setProperty(PROP_APOLLO_META, x));
        Optional.ofNullable(clusterName).ifPresent(x -> System.setProperty(APOLLO_CLUSTER, x));
        Optional.ofNullable(namespace).ifPresent(x -> System.setProperty(APOLLO_NAMESPACE, x));
        Optional.ofNullable(namespace).ifPresent(x -> System.setProperty(APOLLO_NAMESPACE, x));
        this.namespace = namespace;
        this.configService = ConfigService.getAppConfig();
        this.buildClient(config);
    }

    private void buildClient(RegisterConfig config) {
        Properties properties = config.getProps();
        String appId = properties.getProperty("appId");
        String token = properties.getProperty("token");
        String env = properties.getProperty("env", "DEV");
        String clusterName = properties.getProperty("clusterName", "default");
        String namespace = properties.getProperty("namespace", "application");
        String portalUrl = properties.getProperty("portalUrl", "http://localhost:8070");
        ApolloConfig apolloConfig = new ApolloConfig();
        apolloConfig.setAppId(appId);
        apolloConfig.setPortalUrl(portalUrl);
        apolloConfig.setToken(token);
        apolloConfig.setEnv(env);
        apolloConfig.setClusterName(clusterName);
        apolloConfig.setNamespace(namespace);
        this.apolloClient = new ApolloClient(apolloConfig);
    }

    public void persistInstance(InstanceEntity instance) {
        String instanceNodeName = this.buildInstanceNodeName(instance);
        String instancePath = InstancePathConstants.buildInstanceParentPath((String)instance.getAppName());
        String realNode = InstancePathConstants.buildRealNode((String)instancePath, (String)instanceNodeName);
        String nodeData = GsonUtils.getInstance().toJson((Object)instance);
        this.apolloClient.createOrUpdateItem(realNode, nodeData, "register instance");
        this.apolloClient.publishNamespace(this.namespace, "publish instance");
        LOGGER.info("apollo instance register success: {}", (Object)nodeData);
    }

    public List<InstanceEntity> selectInstances(String selectKey) {
        String watchKey = InstancePathConstants.buildInstanceParentPath((String)selectKey);
        Function<Map, List> getInstanceRegisterFun = childrenList -> childrenList.values().stream().map(x -> (InstanceEntity)GsonUtils.getInstance().fromJson(x, InstanceEntity.class)).collect(Collectors.toList());
        HashMap childrenList2 = new HashMap();
        if (this.watcherInstanceRegisterMap.containsKey(selectKey)) {
            return this.watcherInstanceRegisterMap.get(selectKey);
        }
        this.configService.getPropertyNames().forEach(key -> {
            if (key.startsWith(watchKey)) {
                String itemValue = this.apolloClient.getItemValue((String)key);
                childrenList2.put(key, itemValue);
            }
        });
        ConfigChangeListener configChangeListener = changeEvent -> {
            Set keys = changeEvent.changedKeys();
            keys.forEach(key -> {
                if (key.startsWith(watchKey)) {
                    switch (changeEvent.getChange(key).getChangeType()) {
                        case ADDED: {
                            childrenList2.put(key, changeEvent.getChange(key).getNewValue());
                            LOGGER.info("apollo instance register success: {}", (Object)changeEvent.getChange(key).getNewValue());
                            break;
                        }
                        case DELETED: {
                            childrenList2.remove(key);
                            LOGGER.info("apollo instance register delete success: {}", (Object)changeEvent.getChange(key).getOldValue());
                            break;
                        }
                    }
                    this.watcherInstanceRegisterMap.put(selectKey, (List<InstanceEntity>)getInstanceRegisterFun.apply(childrenList2));
                }
            });
        };
        this.configService.addChangeListener(configChangeListener);
        this.configChangeListenerMap.put(watchKey, configChangeListener);
        List instanceEntities = getInstanceRegisterFun.apply(childrenList2);
        this.watcherInstanceRegisterMap.put(selectKey, instanceEntities);
        return instanceEntities;
    }

    private String buildInstanceNodeName(InstanceEntity instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    public void close() {
        this.configChangeListenerMap.forEach((key, value) -> this.configService.removeChangeListener(value));
    }
}

