/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.server.nacos;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.common.utils.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.MapUtils;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterPublisher;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class NacosClientServerRegisterRepository
implements ShenyuClientServerRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosClientServerRegisterRepository.class);
    private static final List<RpcTypeEnum> RPC_URI_TYPE_SET = RpcTypeEnum.acquireSupportURIs();
    private final String defaultGroup = "DEFAULT_GROUP";
    private ConfigService configService;
    private NamingService namingService;
    private ShenyuClientServerRegisterPublisher publisher;
    private final ConcurrentSkipListSet<String> metadataConfigCache = new ConcurrentSkipListSet();
    private final ConcurrentMap<String, ConcurrentSkipListSet<String>> uriServiceCache = new ConcurrentHashMap<String, ConcurrentSkipListSet<String>>();

    public void close() {
        this.publisher.close();
    }

    public void init(ShenyuClientServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.publisher = publisher;
        String serverAddr = config.getServerLists();
        Properties properties = config.getProps();
        Properties nacosProperties = new Properties();
        nacosProperties.put("serverAddr", serverAddr);
        nacosProperties.put("namespace", properties.getProperty("nacosNameSpace"));
        nacosProperties.put("username", properties.getProperty("username", ""));
        nacosProperties.put("password", properties.getProperty("password", ""));
        nacosProperties.put("accessKey", properties.getProperty("accessKey", ""));
        nacosProperties.put("secretKey", properties.getProperty("secretKey", ""));
        try {
            this.configService = ConfigFactory.createConfigService((Properties)nacosProperties);
            this.namingService = NamingFactory.createNamingService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
        this.subscribe();
    }

    private void subscribe() {
        RpcTypeEnum.acquireSupportMetadatas().forEach(this::subscribeRpcTypeService);
    }

    private void subscribeRpcTypeService(RpcTypeEnum rpcType) {
        String serviceName = RegisterPathConstants.buildServiceInstancePath((String)rpcType.getName());
        try {
            HashMap services = new HashMap();
            List healthyInstances = this.namingService.selectInstances(serviceName, true);
            healthyInstances.forEach(healthyInstance -> {
                String contextPath = (String)healthyInstance.getMetadata().get("contextPath");
                String serviceConfigName = RegisterPathConstants.buildServiceConfigPath((String)rpcType.getName(), (String)contextPath);
                this.subscribeMetadata(serviceConfigName);
                this.metadataConfigCache.add(serviceConfigName);
                String metadata = (String)healthyInstance.getMetadata().get("uriMetadata");
                URIRegisterDTO uriRegisterDTO = (URIRegisterDTO)GsonUtils.getInstance().fromJson(metadata, URIRegisterDTO.class);
                ((List)MapUtils.computeIfAbsent((Map)services, (Object)contextPath, k -> new ArrayList())).add(uriRegisterDTO);
                ((ConcurrentSkipListSet)MapUtils.computeIfAbsent(this.uriServiceCache, (Object)serviceName, k -> new ConcurrentSkipListSet())).add(contextPath);
            });
            if (RPC_URI_TYPE_SET.contains(rpcType)) {
                services.values().forEach(this::publishRegisterURI);
            }
            LOGGER.info("subscribe uri : {}", (Object)serviceName);
            this.namingService.subscribe(serviceName, event -> {
                if (event instanceof NamingEvent) {
                    List instances = ((NamingEvent)event).getInstances();
                    instances.forEach(instance -> {
                        String contextPath = (String)instance.getMetadata().get("contextPath");
                        ((ConcurrentSkipListSet)MapUtils.computeIfAbsent(this.uriServiceCache, (Object)serviceName, k -> new ConcurrentSkipListSet())).add(contextPath);
                    });
                    this.refreshURIService(rpcType, serviceName);
                }
            });
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    private void subscribeMetadata(String serviceConfigName) {
        String content = this.readData(serviceConfigName);
        if (StringUtils.isEmpty((String)content)) {
            return;
        }
        this.registerMetadata(content);
        LOGGER.info("subscribe metadata: {}", (Object)serviceConfigName);
        try {
            this.configService.addListener(serviceConfigName, "DEFAULT_GROUP", new Listener(){

                public Executor getExecutor() {
                    return null;
                }

                public void receiveConfigInfo(String config) {
                    NacosClientServerRegisterRepository.this.registerMetadata(config);
                }
            });
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    private void registerMetadata(String metadataConfig) {
        List metadataList = (List)GsonUtils.getInstance().fromJson(metadataConfig, List.class);
        metadataList.forEach(this::publishMetadata);
    }

    private void publishMetadata(String data) {
        LOGGER.info("publish metadata: {}", (Object)data);
        this.publisher.publish((Collection)Lists.newArrayList((Object[])new MetaDataRegisterDTO[]{(MetaDataRegisterDTO)GsonUtils.getInstance().fromJson(data, MetaDataRegisterDTO.class)}));
    }

    private void refreshURIService(RpcTypeEnum rpcType, String serviceName) {
        Optional.ofNullable(this.uriServiceCache.get(serviceName)).ifPresent(services -> services.forEach(contextPath -> this.registerURI((String)contextPath, serviceName, rpcType)));
    }

    private void registerURI(String contextPath, String serviceName, RpcTypeEnum rpcType) {
        try {
            List healthyInstances = this.namingService.selectInstances(serviceName, true);
            ArrayList<URIRegisterDTO> registerDTOList = new ArrayList<URIRegisterDTO>();
            healthyInstances.forEach(healthyInstance -> {
                if (contextPath.equals(healthyInstance.getMetadata().get("contextPath"))) {
                    String metadata = (String)healthyInstance.getMetadata().get("uriMetadata");
                    URIRegisterDTO uriRegisterDTO = (URIRegisterDTO)GsonUtils.getInstance().fromJson(metadata, URIRegisterDTO.class);
                    registerDTOList.add(uriRegisterDTO);
                    String serviceConfigName = RegisterPathConstants.buildServiceConfigPath((String)rpcType.getName(), (String)contextPath);
                    if (!this.metadataConfigCache.contains(serviceConfigName)) {
                        this.subscribeMetadata(serviceConfigName);
                        this.metadataConfigCache.add(serviceConfigName);
                    }
                }
            });
            if (!RPC_URI_TYPE_SET.contains(rpcType)) {
                return;
            }
            if (registerDTOList.isEmpty()) {
                URIRegisterDTO uriRegisterDTO = URIRegisterDTO.builder().contextPath("/" + contextPath).rpcType(rpcType.getName()).build();
                registerDTOList.add(uriRegisterDTO);
            }
            this.publishRegisterURI(registerDTOList);
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    private void publishRegisterURI(List<URIRegisterDTO> registerDTOList) {
        LOGGER.info("publish uri: {}", registerDTOList);
        this.publisher.publish(registerDTOList);
    }

    private String readData(String configName) {
        try {
            return this.configService.getConfig(configName, "DEFAULT_GROUP", 5000L);
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }
}

