/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.elasticsearch.client;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.CreateOperation;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.shenyu.plugin.logging.common.client.AbstractLogConsumeClient;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.elasticsearch.config.ElasticSearchLogCollectConfig;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class ElasticSearchLogCollectClient
extends AbstractLogConsumeClient<ElasticSearchLogCollectConfig.ElasticSearchLogConfig, ShenyuRequestLog> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchLogCollectClient.class);
    private RestClient restClient;
    private ElasticsearchTransport transport;
    private ElasticsearchClient client;

    public void initClient0(@NonNull ElasticSearchLogCollectConfig.ElasticSearchLogConfig config) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(config.getHost(), Integer.parseInt(config.getPort()))});
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getUsername()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getPassword()})) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(config.getUsername(), config.getPassword()));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticSearchLogCollectClient.lambda$initClient0$0(config, (CredentialsProvider)credentialsProvider, arg_0));
        }
        this.restClient = builder.build();
        this.transport = new RestClientTransport(this.restClient, (JsonpMapper)new JacksonJsonpMapper());
        this.client = new ElasticsearchClient(this.transport);
        LOG.info("init ElasticSearchLogCollectClient success");
        if (!this.existsIndex("shenyu-access-logging")) {
            this.createIndex("shenyu-access-logging");
            LOG.info("create index success");
        }
    }

    public void consume0(@NonNull List<ShenyuRequestLog> logs) {
        ArrayList bulkOperations = new ArrayList();
        logs.forEach(log -> {
            try {
                bulkOperations.add(new BulkOperation.Builder().create(d -> (CreateOperation.Builder)d.document(log).index("shenyu-access-logging")).build());
            }
            catch (Exception e) {
                LOG.error("add logs error", (Throwable)e);
            }
        });
        try {
            this.client.bulk(e -> e.index("shenyu-access-logging").operations(bulkOperations));
        }
        catch (Exception e2) {
            LOG.error("elasticsearch store logs error", (Throwable)e2);
        }
    }

    public boolean existsIndex(String indexName) {
        try {
            BooleanResponse existsResponse = this.client.indices().exists(c -> c.index(indexName, new String[0]));
            return existsResponse.value();
        }
        catch (Exception e) {
            LOG.error("fail to check the index exists");
            return true;
        }
    }

    public void createIndex(String indexName) {
        try {
            this.client.indices().create(c -> c.index(indexName));
        }
        catch (IOException e) {
            LOG.error("create index error");
        }
    }

    public void close0() {
        if (Objects.nonNull(this.restClient)) {
            try {
                this.transport.close();
            }
            catch (IOException e) {
                LOG.error("transport close has IOException : ", (Throwable)e);
            }
            try {
                this.restClient.close();
            }
            catch (IOException e) {
                LOG.error("restClient close has IOException : ", (Throwable)e);
            }
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$initClient0$0(ElasticSearchLogCollectConfig.ElasticSearchLogConfig config, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder asyncClientBuilder) {
        if (Boolean.FALSE.equals(config.getAuthCache())) {
            asyncClientBuilder.disableAuthCaching();
        }
        return asyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

