/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.distsql.parser.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.TrafficDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.TrafficDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.traffic.distsql.parser.segment.TrafficRuleSegment;
import org.apache.shardingsphere.traffic.distsql.parser.statement.queryable.ShowTrafficRulesStatement;
import org.apache.shardingsphere.traffic.distsql.parser.statement.updatable.AlterTrafficRuleStatement;
import org.apache.shardingsphere.traffic.distsql.parser.statement.updatable.CreateTrafficRuleStatement;
import org.apache.shardingsphere.traffic.distsql.parser.statement.updatable.DropTrafficRuleStatement;

public final class TrafficDistSQLStatementVisitor
extends TrafficDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitCreateTrafficRule(TrafficDistSQLStatementParser.CreateTrafficRuleContext ctx) {
        return new CreateTrafficRuleStatement((Collection)ctx.trafficRuleDefinition().stream().map(each -> (TrafficRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterTrafficRule(TrafficDistSQLStatementParser.AlterTrafficRuleContext ctx) {
        return new AlterTrafficRuleStatement((Collection)ctx.trafficRuleDefinition().stream().map(each -> (TrafficRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitTrafficRuleDefinition(TrafficDistSQLStatementParser.TrafficRuleDefinitionContext ctx) {
        AlgorithmSegment loadBalancerSegment = null;
        if (null != ctx.loadBalancerDefinition()) {
            loadBalancerSegment = (AlgorithmSegment)this.visit((ParseTree)ctx.loadBalancerDefinition().algorithmDefinition());
        }
        return new TrafficRuleSegment(this.getIdentifierValue((ParseTree)ctx.ruleName()), this.buildLabels(ctx.labelDefinition()), (AlgorithmSegment)this.visit((ParseTree)ctx.trafficAlgorithmDefinition().algorithmDefinition()), loadBalancerSegment);
    }

    private Collection<String> buildLabels(TrafficDistSQLStatementParser.LabelDefinitionContext labelDefinition) {
        return null == labelDefinition ? Collections.emptyList() : (Collection)labelDefinition.label().stream().map(this::getIdentifierValue).collect(Collectors.toList());
    }

    @Override
    public ASTNode visitLoadBalancerDefinition(TrafficDistSQLStatementParser.LoadBalancerDefinitionContext ctx) {
        return null == ctx ? null : (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    @Override
    public ASTNode visitAlgorithmDefinition(TrafficDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.buildProperties(ctx.propertiesDefinition()));
    }

    private Properties buildProperties(TrafficDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx) {
            return result;
        }
        for (TrafficDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitDropTrafficRule(TrafficDistSQLStatementParser.DropTrafficRuleContext ctx) {
        Collection ruleNames = null == ctx.ruleName() ? null : (Collection)ctx.ruleName().stream().map(this::getIdentifierValue).collect(Collectors.toSet());
        return new DropTrafficRuleStatement(null != ctx.ifExists(), ruleNames);
    }

    @Override
    public ASTNode visitShowTrafficRules(TrafficDistSQLStatementParser.ShowTrafficRulesContext ctx) {
        return new ShowTrafficRulesStatement(null == ctx.ruleName() ? null : this.getIdentifierValue((ParseTree)ctx.ruleName()));
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }
}

