/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.predicate;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.sql.constant.LogicalOperator;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.OrPredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;

public final class PredicateBuilder {
    private final ASTNode left;
    private final ASTNode right;
    private final String operator;

    public OrPredicateSegment mergePredicate() {
        Optional<LogicalOperator> logicalOperator = LogicalOperator.valueFrom(this.operator);
        Preconditions.checkState((boolean)logicalOperator.isPresent());
        return LogicalOperator.OR == logicalOperator.get() ? this.mergeOrPredicateSegment() : this.mergeAndPredicateSegment();
    }

    private OrPredicateSegment mergeOrPredicateSegment() {
        OrPredicateSegment result = new OrPredicateSegment();
        result.getAndPredicates().addAll(this.getAndPredicates(this.left));
        result.getAndPredicates().addAll(this.getAndPredicates(this.right));
        return result;
    }

    private OrPredicateSegment mergeAndPredicateSegment() {
        OrPredicateSegment result = new OrPredicateSegment();
        Collection<AndPredicate> leftPredicates = this.getAndPredicates(this.left);
        Collection<AndPredicate> rightPredicates = this.getAndPredicates(this.right);
        this.addAndPredicates(result, leftPredicates, rightPredicates);
        return result;
    }

    private void addAndPredicates(OrPredicateSegment orPredicateSegment, Collection<AndPredicate> leftPredicates, Collection<AndPredicate> rightPredicates) {
        if (0 == leftPredicates.size() && 0 == rightPredicates.size()) {
            return;
        }
        if (0 == leftPredicates.size()) {
            orPredicateSegment.getAndPredicates().addAll(rightPredicates);
        }
        if (0 == rightPredicates.size()) {
            orPredicateSegment.getAndPredicates().addAll(leftPredicates);
        }
        for (AndPredicate eachLeft : leftPredicates) {
            for (AndPredicate eachRight : rightPredicates) {
                orPredicateSegment.getAndPredicates().add(this.createAndPredicate(eachLeft, eachRight));
            }
        }
    }

    private Collection<AndPredicate> getAndPredicates(ASTNode astNode) {
        if (astNode instanceof OrPredicateSegment) {
            return ((OrPredicateSegment)astNode).getAndPredicates();
        }
        if (astNode instanceof AndPredicate) {
            return Collections.singleton((AndPredicate)astNode);
        }
        if (astNode instanceof PredicateSegment) {
            AndPredicate andPredicate = new AndPredicate();
            andPredicate.getPredicates().add((PredicateSegment)astNode);
            return Collections.singleton(andPredicate);
        }
        return new LinkedList<AndPredicate>();
    }

    private AndPredicate createAndPredicate(AndPredicate left, AndPredicate right) {
        AndPredicate result = new AndPredicate();
        result.getPredicates().addAll(left.getPredicates());
        result.getPredicates().addAll(right.getPredicates());
        return result;
    }

    @Generated
    public PredicateBuilder(ASTNode left, ASTNode right, String operator) {
        this.left = left;
        this.right = right;
        this.operator = operator;
    }
}

