/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sqlserver.visitor.statement.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DCLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerAlterLoginStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerAlterRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerAlterUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerCreateLoginStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerCreateRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerCreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerDenyUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerDropLoginStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerDropRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerDropUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerGrantStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerRevokeStatement;
import org.apache.shardingsphere.sql.parser.sqlserver.visitor.statement.impl.SQLServerStatementSQLVisitor;

public final class SQLServerDCLStatementSQLVisitor
extends SQLServerStatementSQLVisitor
implements DCLSQLVisitor,
SQLStatementVisitor {
    public SQLServerDCLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitGrant(SQLServerStatementParser.GrantContext ctx) {
        SQLServerGrantStatement result = new SQLServerGrantStatement();
        if (null != ctx.classPrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classPrivilegesClause())) {
                result.getTables().add(each);
            }
        }
        if (null != ctx.classTypePrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classTypePrivilegesClause())) {
                result.getTables().add(each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(SQLServerStatementParser.RevokeContext ctx) {
        SQLServerRevokeStatement result = new SQLServerRevokeStatement();
        if (null != ctx.classPrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classPrivilegesClause())) {
                result.getTables().add(each);
            }
        }
        if (null != ctx.classTypePrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classTypePrivilegesClause())) {
                result.getTables().add(each);
            }
        }
        return result;
    }

    private Collection<SimpleTableSegment> getTableFromPrivilegeClause(SQLServerStatementParser.ClassPrivilegesClauseContext ctx) {
        return null == ctx.onClassClause().tableName() ? Collections.emptyList() : Collections.singletonList((SimpleTableSegment)this.visit((ParseTree)ctx.onClassClause().tableName()));
    }

    private Collection<SimpleTableSegment> getTableFromPrivilegeClause(SQLServerStatementParser.ClassTypePrivilegesClauseContext ctx) {
        return null == ctx.onClassTypeClause().tableName() ? Collections.emptyList() : Collections.singletonList((SimpleTableSegment)this.visit((ParseTree)ctx.onClassTypeClause().tableName()));
    }

    @Override
    public ASTNode visitCreateUser(SQLServerStatementParser.CreateUserContext ctx) {
        return new SQLServerCreateUserStatement();
    }

    @Override
    public ASTNode visitAlterUser(SQLServerStatementParser.AlterUserContext ctx) {
        return new SQLServerAlterUserStatement();
    }

    @Override
    public ASTNode visitDeny(SQLServerStatementParser.DenyContext ctx) {
        SQLServerDenyUserStatement result = new SQLServerDenyUserStatement();
        if (null != ctx.classPrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classPrivilegesClause())) {
                result.setTable(each);
            }
        }
        if (null != ctx.classTypePrivilegesClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.classTypePrivilegesClause())) {
                result.setTable(each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitDropUser(SQLServerStatementParser.DropUserContext ctx) {
        return new SQLServerDropUserStatement();
    }

    @Override
    public ASTNode visitCreateRole(SQLServerStatementParser.CreateRoleContext ctx) {
        return new SQLServerCreateRoleStatement();
    }

    @Override
    public ASTNode visitAlterRole(SQLServerStatementParser.AlterRoleContext ctx) {
        return new SQLServerAlterRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(SQLServerStatementParser.DropRoleContext ctx) {
        return new SQLServerDropRoleStatement();
    }

    @Override
    public ASTNode visitCreateLogin(SQLServerStatementParser.CreateLoginContext ctx) {
        return new SQLServerCreateLoginStatement();
    }

    @Override
    public ASTNode visitAlterLogin(SQLServerStatementParser.AlterLoginContext ctx) {
        return new SQLServerAlterLoginStatement();
    }

    @Override
    public ASTNode visitDropLogin(SQLServerStatementParser.DropLoginContext ctx) {
        return new SQLServerDropLoginStatement();
    }

    @Generated
    public SQLServerDCLStatementSQLVisitor() {
    }
}

