/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.api.sharding.standard;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.datanode.DataNodeInfo;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public interface StandardShardingAlgorithm<T extends Comparable<?>>
extends ShardingAlgorithm {
    public String doSharding(Collection<String> var1, PreciseShardingValue<T> var2);

    public Collection<String> doSharding(Collection<String> var1, RangeShardingValue<T> var2);

    default public Optional<String> findMatchedTargetName(Collection<String> availableTargetNames, String suffix, DataNodeInfo dataNodeInfo) {
        String result = dataNodeInfo.getPrefix() + Strings.padStart((String)suffix, (int)dataNodeInfo.getSuffixMinLength(), (char)dataNodeInfo.getPaddingChar());
        if (availableTargetNames.contains(result)) {
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

