/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser.sql;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngine;
import org.apache.shardingsphere.sql.parser.api.CacheOption;

public final class SQLStatementParserEngineFactory {
    private static final Map<DatabaseType, SQLStatementParserEngine> ENGINES = new ConcurrentHashMap<DatabaseType, SQLStatementParserEngine>();

    public static SQLStatementParserEngine getSQLStatementParserEngine(DatabaseType databaseType, CacheOption sqlStatementCacheOption, CacheOption parseTreeCacheOption, boolean isParseComment) {
        SQLStatementParserEngine result = ENGINES.get(databaseType);
        if (null == result) {
            result = ENGINES.computeIfAbsent(databaseType, key -> new SQLStatementParserEngine((DatabaseType)key, sqlStatementCacheOption, parseTreeCacheOption, isParseComment));
        } else if (!result.getSqlStatementCacheOption().equals((Object)sqlStatementCacheOption) || !result.getParseTreeCacheOption().equals((Object)parseTreeCacheOption) || result.isParseComment() != isParseComment) {
            result = new SQLStatementParserEngine(databaseType, sqlStatementCacheOption, parseTreeCacheOption, isParseComment);
            ENGINES.put(databaseType, result);
        }
        return result;
    }

    @Generated
    private SQLStatementParserEngineFactory() {
    }
}

