/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.sqlbuilder;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.AbstractPipelineSQLBuilder;

public final class OpenGaussPipelineSQLBuilder
extends AbstractPipelineSQLBuilder {
    public String buildCreateSchemaSQL(String schemaName) {
        return "CREATE SCHEMA " + this.quote(schemaName);
    }

    public String getLeftIdentifierQuoteString() {
        return "";
    }

    public String getRightIdentifierQuoteString() {
        return "";
    }

    public String buildInsertSQL(String schemaName, DataRecord dataRecord, Map<LogicTableName, Set<String>> shardingColumnsMap) {
        return super.buildInsertSQL(schemaName, dataRecord, shardingColumnsMap) + this.buildConflictSQL(shardingColumnsMap);
    }

    public List<Column> extractUpdatedColumns(DataRecord record, Map<LogicTableName, Set<String>> shardingColumnsMap) {
        return record.getColumns().stream().filter(each -> !each.isUniqueKey() && !this.isShardingColumn(shardingColumnsMap, record.getTableName(), each.getName())).collect(Collectors.toList());
    }

    private String buildConflictSQL(Map<LogicTableName, Set<String>> shardingColumnsMap) {
        return "";
    }

    public String getType() {
        return "openGauss";
    }
}

