/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.prepare.datasource;

import com.google.common.base.Splitter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;
import org.apache.shardingsphere.data.pipeline.core.metadata.generator.PipelineDDLGenerator;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.AbstractDataSourcePreparer;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetTablesParameter;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OpenGaussDatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussDataSourcePreparer
extends AbstractDataSourcePreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussDataSourcePreparer.class);

    public void prepareTargetTables(PrepareTargetTablesParameter parameter) {
        List<String> createLogicalTableSQLs = this.listCreateLogicalTableSQL(parameter);
        try (Connection targetConnection = this.getTargetCachedDataSource(parameter.getTaskConfig(), parameter.getDataSourceManager()).getConnection();){
            for (String createLogicalTableSQL : createLogicalTableSQLs) {
                for (String each : Splitter.on((String)";").splitToList((CharSequence)createLogicalTableSQL).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList())) {
                    this.executeTargetTableSQL(targetConnection, each);
                }
            }
        }
        catch (SQLException ex) {
            throw new PipelineJobPrepareFailedException("prepare target tables failed.", (Throwable)ex);
        }
    }

    private List<String> listCreateLogicalTableSQL(PrepareTargetTablesParameter parameter) {
        PipelineDDLGenerator generator = new PipelineDDLGenerator(PipelineContext.getContextManager());
        LinkedList<String> result = new LinkedList<String>();
        for (JobDataNodeEntry each : parameter.getTablesFirstDataNodes().getEntries()) {
            String schemaName = parameter.getTableNameSchemaNameMapping().getSchemaName(each.getLogicTableName());
            result.add(generator.generateLogicDDLSQL((DatabaseType)new OpenGaussDatabaseType(), parameter.getJobConfig().getDatabaseName(), schemaName, each.getLogicTableName()));
        }
        return result;
    }
}

