/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.ingest.wal.decode;

import com.google.gson.Gson;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.exception.IngestException;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.wal.decode.MppTableData;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.BaseLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.BaseTimestampUtils;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.DecodingException;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.DecodingPlugin;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.AbstractRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.AbstractWalEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.DeleteRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.PlaceholderEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.UpdateRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.WriteRowEvent;
import org.opengauss.util.PGInterval;
import org.opengauss.util.PGobject;

public final class MppdbDecodingPlugin
implements DecodingPlugin {
    private final BaseTimestampUtils timestampUtils;

    public AbstractWalEvent decode(ByteBuffer data, BaseLogSequenceNumber logSequenceNumber) {
        char eventType = this.readOneChar(data);
        Object result = '{' == eventType ? this.readTableEvent(this.readMppData(data)) : new PlaceholderEvent();
        result.setLogSequenceNumber(logSequenceNumber);
        return result;
    }

    private char readOneChar(ByteBuffer data) {
        return (char)data.get();
    }

    private String readMppData(ByteBuffer data) {
        int optDepth;
        StringBuilder mppData = new StringBuilder();
        mppData.append('{');
        for (int depth = 1; depth != 0 && data.hasRemaining(); depth += optDepth) {
            char next = (char)data.get();
            mppData.append(next);
            optDepth = '{' == next ? 1 : ('}' == next ? -1 : 0);
        }
        return mppData.toString();
    }

    private AbstractRowEvent readTableEvent(String mppData) {
        AbstractRowEvent result;
        String rowEventType;
        Gson mppDataGson = new Gson();
        MppTableData mppTableData = (MppTableData)mppDataGson.fromJson(mppData, MppTableData.class);
        switch (rowEventType = mppTableData.getOpType()) {
            case "INSERT": {
                result = this.readWriteRowEvent(mppTableData);
                break;
            }
            case "UPDATE": {
                result = this.readUpdateRowEvent(mppTableData);
                break;
            }
            case "DELETE": {
                result = this.readDeleteRowEvent(mppTableData);
                break;
            }
            default: {
                throw new IngestException("Unknown rowEventType: " + rowEventType);
            }
        }
        String[] tableMetaData = mppTableData.getTableName().split("\\.");
        result.setDatabaseName(tableMetaData[0]);
        result.setTableName(tableMetaData[1]);
        return result;
    }

    private AbstractRowEvent readWriteRowEvent(MppTableData data) {
        WriteRowEvent result = new WriteRowEvent();
        result.setAfterRow(this.getColumnDataFromMppDataEvent(data));
        return result;
    }

    private AbstractRowEvent readUpdateRowEvent(MppTableData data) {
        UpdateRowEvent result = new UpdateRowEvent();
        result.setAfterRow(this.getColumnDataFromMppDataEvent(data));
        return result;
    }

    private AbstractRowEvent readDeleteRowEvent(MppTableData data) {
        DeleteRowEvent result = new DeleteRowEvent();
        result.setPrimaryKeys(this.getDeleteColumnDataFromMppDataEvent(data));
        return result;
    }

    private List<Object> getColumnDataFromMppDataEvent(MppTableData data) {
        ArrayList<Object> result = new ArrayList<Object>(data.getColumnsType().length);
        for (int i = 0; i < data.getColumnsType().length; ++i) {
            result.add(this.readColumnData(data.getColumnsVal()[i], data.getColumnsType()[i]));
        }
        return result;
    }

    private List<Object> getDeleteColumnDataFromMppDataEvent(MppTableData data) {
        ArrayList<Object> result = new ArrayList<Object>(data.getOldKeysType().length);
        for (int i = 0; i < data.getOldKeysType().length; ++i) {
            result.add(this.readColumnData(data.getOldKeysVal()[i], data.getOldKeysType()[i]));
        }
        return result;
    }

    private Object readColumnData(String data, String columnType) {
        if (columnType.startsWith("numeric")) {
            return new BigDecimal(data);
        }
        if (columnType.startsWith("bit")) {
            return MppdbDecodingPlugin.decodeString(data.substring(1));
        }
        switch (columnType) {
            case "smallint": {
                return Short.parseShort(data);
            }
            case "integer": {
                return Integer.parseInt(data);
            }
            case "bigint": {
                return Long.parseLong(data);
            }
            case "real": {
                return Float.valueOf(Float.parseFloat(data));
            }
            case "double precision": {
                return Double.parseDouble(data);
            }
            case "boolean": {
                return Boolean.parseBoolean(data);
            }
            case "time without time zone": 
            case "time with time zone": {
                try {
                    return this.timestampUtils.toTime(null, MppdbDecodingPlugin.decodeString(data));
                }
                catch (SQLException ex) {
                    throw new DecodingException((Throwable)ex);
                }
            }
            case "date": {
                return Date.valueOf(MppdbDecodingPlugin.decodeString(data));
            }
            case "timestamp without time zone": 
            case "timestamp with time zone": 
            case "smalldatetime": {
                try {
                    return this.timestampUtils.toTimestamp(null, MppdbDecodingPlugin.decodeString(data));
                }
                catch (SQLException ex) {
                    throw new DecodingException((Throwable)ex);
                }
            }
            case "bytea": {
                return MppdbDecodingPlugin.decodeBytea(data);
            }
            case "raw": 
            case "reltime": {
                return MppdbDecodingPlugin.decodePgObject(data, columnType);
            }
            case "money": {
                return MppdbDecodingPlugin.decodeMoney(data);
            }
            case "interval": {
                return MppdbDecodingPlugin.decodeInterval(data);
            }
        }
        return MppdbDecodingPlugin.decodeString(data);
    }

    private static PGobject decodeInterval(String data) {
        try {
            return new PGInterval(MppdbDecodingPlugin.decodeString(data));
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    private static PGobject decodePgObject(String data, String type) {
        try {
            PGobject result = new PGobject();
            result.setType(type);
            result.setValue(MppdbDecodingPlugin.decodeString(data));
            return result;
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    private static PGobject decodeBytea(String data) {
        try {
            PGobject result = new PGobject();
            result.setType("bytea");
            byte[] decodeByte = MppdbDecodingPlugin.decodeHex(MppdbDecodingPlugin.decodeString(data).substring(2));
            result.setValue(new String(decodeByte));
            return result;
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    private static String decodeMoney(String data) {
        String result = MppdbDecodingPlugin.decodeString(data);
        return '$' == result.charAt(0) ? result.substring(1) : result;
    }

    private static String decodeString(String data) {
        if (data.length() > 1) {
            int begin = '\'' == data.charAt(0) ? 1 : 0;
            int end = data.length() + (data.charAt(data.length() - 1) == '\'' ? -1 : 0);
            return data.substring(begin, end);
        }
        return data;
    }

    private static byte[] decodeHex(String hexString) {
        int dataLength = hexString.length();
        if (0 != (dataLength & 1)) {
            throw new IllegalArgumentException(String.format("Illegal hex data %s", hexString));
        }
        if (0 == dataLength) {
            return new byte[0];
        }
        byte[] result = new byte[dataLength >>> 1];
        for (int i = 0; i < dataLength; i += 2) {
            result[i >>> 1] = MppdbDecodingPlugin.decodeHexByte(hexString, i);
        }
        return result;
    }

    private static byte decodeHexByte(String hexString, int index) {
        int firstHexChar = Character.digit(hexString.charAt(index), 16);
        int secondHexChar = Character.digit(hexString.charAt(index + 1), 16);
        if (-1 == firstHexChar || -1 == secondHexChar) {
            throw new IllegalArgumentException(String.format("Illegal hex byte '%s' in index %d", hexString, index));
        }
        return (byte)((firstHexChar << 4) + secondHexChar);
    }

    @Generated
    public MppdbDecodingPlugin(BaseTimestampUtils timestampUtils) {
        this.timestampUtils = timestampUtils;
    }
}

