/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.ingest;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.AbstractIncrementalDumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.exception.IngestException;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.util.ThreadUtil;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.OpenGaussPositionInitializer;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.wal.OpenGaussLogicalReplication;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.wal.decode.MppdbDecodingPlugin;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.wal.decode.OpenGaussLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.wal.decode.OpenGaussTimestampUtils;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.WalEventConverter;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.WalPosition;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.AbstractWalEvent;
import org.opengauss.jdbc.PgConnection;
import org.opengauss.replication.PGReplicationStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussWalDumper
extends AbstractIncrementalDumper<WalPosition> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussWalDumper.class);
    private final WalPosition walPosition;
    private final DumperConfiguration dumperConfig;
    private final OpenGaussLogicalReplication logicalReplication = new OpenGaussLogicalReplication();
    private final WalEventConverter walEventConverter;
    private final PipelineChannel channel;

    public OpenGaussWalDumper(DumperConfiguration dumperConfig, IngestPosition<WalPosition> position, PipelineChannel channel, PipelineTableMetaDataLoader metaDataLoader) {
        super(dumperConfig, position, channel, metaDataLoader);
        this.walPosition = (WalPosition)position;
        if (!StandardPipelineDataSourceConfiguration.class.equals(dumperConfig.getDataSourceConfig().getClass())) {
            throw new UnsupportedOperationException("PostgreSQLWalDumper only support PipelineDataSourceConfiguration");
        }
        this.dumperConfig = dumperConfig;
        this.channel = channel;
        this.walEventConverter = new WalEventConverter(dumperConfig, metaDataLoader);
    }

    protected void doStart() {
        this.dump();
    }

    private void dump() {
        PGReplicationStream stream = null;
        try (PgConnection connection = this.getReplicationConnectionUnwrap();){
            stream = this.logicalReplication.createReplicationStream(connection, this.walPosition.getLogSequenceNumber(), OpenGaussPositionInitializer.getUniqueSlotName((Connection)connection));
            MppdbDecodingPlugin decodingPlugin = new MppdbDecodingPlugin(new OpenGaussTimestampUtils(connection.getTimestampUtils()));
            while (this.isRunning()) {
                ByteBuffer message = stream.readPending();
                if (null == message) {
                    ThreadUtil.sleep((long)10L);
                    continue;
                }
                AbstractWalEvent event = decodingPlugin.decode(message, new OpenGaussLogSequenceNumber(stream.getLastReceiveLSN()));
                Record record = this.walEventConverter.convert(event);
                this.pushRecord(record);
            }
        }
        catch (SQLException ex) {
            throw new IngestException((Throwable)ex);
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private PgConnection getReplicationConnectionUnwrap() throws SQLException {
        return this.logicalReplication.createConnection((StandardPipelineDataSourceConfiguration)this.dumperConfig.getDataSourceConfig()).unwrap(PgConnection.class);
    }

    private void pushRecord(Record record) {
        this.channel.pushRecord(record);
    }

    protected void doStop() {
    }
}

