/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.ingest;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.wal.decode.OpenGaussLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.WalPosition;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.BaseLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.spi.ingest.position.PositionInitializer;
import org.opengauss.replication.LogSequenceNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussPositionInitializer
implements PositionInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussPositionInitializer.class);
    private static final String SLOT_NAME_PREFIX = "sharding_scaling";
    private static final String DECODE_PLUGIN = "mppdb_decoding";
    private static final String DUPLICATE_OBJECT_ERROR_CODE = "42710";

    public WalPosition init(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.createSlotIfNotExist(connection);
            WalPosition walPosition = this.getWalPosition(connection);
            return walPosition;
        }
    }

    public WalPosition init(String data) {
        return new WalPosition((BaseLogSequenceNumber)new OpenGaussLogSequenceNumber(LogSequenceNumber.valueOf((long)Long.parseLong(data))));
    }

    private void createSlotIfNotExist(Connection connection) throws SQLException {
        String slotName = OpenGaussPositionInitializer.getUniqueSlotName(connection);
        if (!this.isSlotExist(connection, slotName)) {
            this.createSlotBySQL(connection);
        }
    }

    private boolean isSlotExist(Connection connection, String slotName) throws SQLException {
        String sql = "SELECT slot_name FROM pg_replication_slots WHERE slot_name=? AND plugin=?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            boolean bl;
            block12: {
                preparedStatement.setString(1, slotName);
                preparedStatement.setString(2, DECODE_PLUGIN);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
    }

    private void createSlotBySQL(Connection connection) throws SQLException {
        block8: {
            String sql = String.format("SELECT * FROM pg_create_logical_replication_slot('%s', '%s')", OpenGaussPositionInitializer.getUniqueSlotName(connection), DECODE_PLUGIN);
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                preparedStatement.execute();
            }
            catch (SQLException ex) {
                if (DUPLICATE_OBJECT_ERROR_CODE.equals(ex.getSQLState())) break block8;
                throw ex;
            }
        }
    }

    private WalPosition getWalPosition(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT PG_CURRENT_XLOG_LOCATION()");){
            WalPosition walPosition;
            block12: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    resultSet.next();
                    walPosition = new WalPosition((BaseLogSequenceNumber)new OpenGaussLogSequenceNumber(LogSequenceNumber.valueOf((String)resultSet.getString(1))));
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return walPosition;
        }
    }

    public void destroy(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.dropSlotIfExist(connection);
        }
    }

    private void dropSlotIfExist(Connection connection) throws SQLException {
        String slotName = OpenGaussPositionInitializer.getUniqueSlotName(connection);
        if (!this.isSlotExist(connection, slotName)) {
            log.info("dropSlotIfExist, slot not exist, ignore, slotName={}", (Object)slotName);
            return;
        }
        String sql = String.format("select * from pg_drop_replication_slot('%s')", slotName);
        try (CallableStatement callableStatement = connection.prepareCall(sql);){
            callableStatement.execute();
        }
    }

    public static String getUniqueSlotName(Connection connection) throws SQLException {
        return String.format("%s_%s", SLOT_NAME_PREFIX, connection.getCatalog());
    }

    public String getType() {
        return "openGauss";
    }
}

