/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.ddlgenerator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.spi.ddlgenerator.CreateTableSQLGenerator;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;

public final class OpenGaussCreateTableSQLGenerator
implements CreateTableSQLGenerator {
    private static final String SELECT_TABLE_DEF_SQL = "SELECT * FROM pg_get_tabledef('%s.%s')";
    private static final String COLUMN_LABEL = "pg_get_tabledef";

    public String generate(String tableName, String schemaName, DataSource dataSource) throws SQLException {
        try (Statement statement = dataSource.getConnection().createStatement();
             ResultSet resultSet = statement.executeQuery(String.format(SELECT_TABLE_DEF_SQL, schemaName, tableName));){
            if (resultSet.next()) {
                String string = resultSet.getString(COLUMN_LABEL);
                return string;
            }
        }
        throw new ShardingSphereException("Failed to get ddl sql for table %s", new Object[]{tableName});
    }

    public String getType() {
        return "openGauss";
    }
}

