/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class TxnOffsetCommitResponse
extends AbstractResponse {
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final Schema TXN_OFFSET_COMMIT_PARTITION_ERROR_RESPONSE_V0 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE);
    private static final Schema TXN_OFFSET_COMMIT_RESPONSE_V0;
    private static final Schema TXN_OFFSET_COMMIT_RESPONSE_V1;
    private final Map<TopicPartition, Errors> errors;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{TXN_OFFSET_COMMIT_RESPONSE_V0, TXN_OFFSET_COMMIT_RESPONSE_V1};
    }

    public TxnOffsetCommitResponse(int throttleTimeMs, Map<TopicPartition, Errors> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public TxnOffsetCommitResponse(Struct struct) {
        Object[] topicPartitionsArray;
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        for (Object topicPartitionObj : topicPartitionsArray = struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicPartitionStruct = (Struct)topicPartitionObj;
            String topic = topicPartitionStruct.get(CommonFields.TOPIC_NAME);
            for (Object partitionObj : topicPartitionStruct.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionStruct = (Struct)partitionObj;
                Integer partition2 = partitionStruct.get(CommonFields.PARTITION_ID);
                Errors error = Errors.forCode(partitionStruct.get(CommonFields.ERROR_CODE));
                errors.put(new TopicPartition(topic, partition2), error);
            }
        }
        this.errors = errors;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.TXN_OFFSET_COMMIT.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        Map<String, Map<Integer, Errors>> mappedPartitions = CollectionUtils.groupDataByTopic(this.errors);
        Object[] partitionsArray = new Object[mappedPartitions.size()];
        int i = 0;
        for (Map.Entry<String, Map<Integer, Errors>> topicAndPartitions : mappedPartitions.entrySet()) {
            Struct topicPartitionsStruct = struct.instance(TOPICS_KEY_NAME);
            topicPartitionsStruct.set(CommonFields.TOPIC_NAME, topicAndPartitions.getKey());
            Map<Integer, Errors> partitionAndErrors = topicAndPartitions.getValue();
            Object[] partitionAndErrorsArray = new Object[partitionAndErrors.size()];
            int j = 0;
            for (Map.Entry<Integer, Errors> partitionAndError : partitionAndErrors.entrySet()) {
                Struct partitionAndErrorStruct = topicPartitionsStruct.instance(PARTITIONS_KEY_NAME);
                partitionAndErrorStruct.set(CommonFields.PARTITION_ID, partitionAndError.getKey());
                partitionAndErrorStruct.set(CommonFields.ERROR_CODE, partitionAndError.getValue().code());
                partitionAndErrorsArray[j++] = partitionAndErrorStruct;
            }
            topicPartitionsStruct.set(PARTITIONS_KEY_NAME, (Object)partitionAndErrorsArray);
            partitionsArray[i++] = topicPartitionsStruct;
        }
        struct.set(TOPICS_KEY_NAME, (Object)partitionsArray);
        return struct;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<TopicPartition, Errors> errors() {
        return this.errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.errors);
    }

    public static TxnOffsetCommitResponse parse(ByteBuffer buffer, short version) {
        return new TxnOffsetCommitResponse(ApiKeys.TXN_OFFSET_COMMIT.parseResponse(version, buffer));
    }

    public String toString() {
        return "TxnOffsetCommitResponse(errors=" + this.errors + ", throttleTimeMs=" + this.throttleTimeMs + ')';
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    static {
        TXN_OFFSET_COMMIT_RESPONSE_V1 = TXN_OFFSET_COMMIT_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(TOPICS_KEY_NAME, new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field(PARTITIONS_KEY_NAME, new ArrayOf(TXN_OFFSET_COMMIT_PARTITION_ERROR_RESPONSE_V0)))), "Errors per partition from writing markers."));
    }
}

