/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.util.Objects;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Utils;

public class KafkaChannel {
    private final String id;
    private final TransportLayer transportLayer;
    private final Authenticator authenticator;
    private long networkThreadTimeNanos;
    private final int maxReceiveSize;
    private final MemoryPool memoryPool;
    private NetworkReceive receive;
    private Send send;
    private boolean disconnected;
    private ChannelMuteState muteState;
    private ChannelState state;

    public KafkaChannel(String id, TransportLayer transportLayer, Authenticator authenticator, int maxReceiveSize, MemoryPool memoryPool) throws IOException {
        this.id = id;
        this.transportLayer = transportLayer;
        this.authenticator = authenticator;
        this.networkThreadTimeNanos = 0L;
        this.maxReceiveSize = maxReceiveSize;
        this.memoryPool = memoryPool;
        this.disconnected = false;
        this.muteState = ChannelMuteState.NOT_MUTED;
        this.state = ChannelState.NOT_CONNECTED;
    }

    public void close() throws IOException {
        this.disconnected = true;
        Utils.closeAll(this.transportLayer, this.authenticator, this.receive);
    }

    public KafkaPrincipal principal() {
        return this.authenticator.principal();
    }

    public void prepare() throws AuthenticationException, IOException {
        try {
            if (!this.transportLayer.ready()) {
                this.transportLayer.handshake();
            }
            if (this.transportLayer.ready() && !this.authenticator.complete()) {
                this.authenticator.authenticate();
            }
        }
        catch (AuthenticationException e) {
            this.state = new ChannelState(ChannelState.State.AUTHENTICATION_FAILED, e);
            throw e;
        }
        if (this.ready()) {
            this.state = ChannelState.READY;
        }
    }

    public void disconnect() {
        this.disconnected = true;
        this.transportLayer.disconnect();
    }

    public void state(ChannelState state) {
        this.state = state;
    }

    public ChannelState state() {
        return this.state;
    }

    public boolean finishConnect() throws IOException {
        boolean connected = this.transportLayer.finishConnect();
        if (connected) {
            this.state = this.ready() ? ChannelState.READY : ChannelState.AUTHENTICATE;
        }
        return connected;
    }

    public boolean isConnected() {
        return this.transportLayer.isConnected();
    }

    public String id() {
        return this.id;
    }

    public SelectionKey selectionKey() {
        return this.transportLayer.selectionKey();
    }

    void mute() {
        if (this.muteState == ChannelMuteState.NOT_MUTED) {
            if (!this.disconnected) {
                this.transportLayer.removeInterestOps(1);
            }
            this.muteState = ChannelMuteState.MUTED;
        }
    }

    boolean maybeUnmute() {
        if (this.muteState == ChannelMuteState.MUTED) {
            if (!this.disconnected) {
                this.transportLayer.addInterestOps(1);
            }
            this.muteState = ChannelMuteState.NOT_MUTED;
        }
        return this.muteState == ChannelMuteState.NOT_MUTED;
    }

    public void handleChannelMuteEvent(ChannelMuteEvent event) {
        boolean stateChanged = false;
        switch (event) {
            case REQUEST_RECEIVED: {
                if (this.muteState != ChannelMuteState.MUTED) break;
                this.muteState = ChannelMuteState.MUTED_AND_RESPONSE_PENDING;
                stateChanged = true;
                break;
            }
            case RESPONSE_SENT: {
                if (this.muteState == ChannelMuteState.MUTED_AND_RESPONSE_PENDING) {
                    this.muteState = ChannelMuteState.MUTED;
                    stateChanged = true;
                }
                if (this.muteState != ChannelMuteState.MUTED_AND_THROTTLED_AND_RESPONSE_PENDING) break;
                this.muteState = ChannelMuteState.MUTED_AND_THROTTLED;
                stateChanged = true;
                break;
            }
            case THROTTLE_STARTED: {
                if (this.muteState != ChannelMuteState.MUTED_AND_RESPONSE_PENDING) break;
                this.muteState = ChannelMuteState.MUTED_AND_THROTTLED_AND_RESPONSE_PENDING;
                stateChanged = true;
                break;
            }
            case THROTTLE_ENDED: {
                if (this.muteState == ChannelMuteState.MUTED_AND_THROTTLED) {
                    this.muteState = ChannelMuteState.MUTED;
                    stateChanged = true;
                }
                if (this.muteState != ChannelMuteState.MUTED_AND_THROTTLED_AND_RESPONSE_PENDING) break;
                this.muteState = ChannelMuteState.MUTED_AND_RESPONSE_PENDING;
                stateChanged = true;
            }
        }
        if (!stateChanged) {
            throw new IllegalStateException("Cannot transition from " + this.muteState.name() + " for " + event.name());
        }
    }

    public ChannelMuteState muteState() {
        return this.muteState;
    }

    public boolean isMute() {
        return this.muteState != ChannelMuteState.NOT_MUTED;
    }

    public boolean isInMutableState() {
        if (this.receive == null || this.receive.memoryAllocated()) {
            return false;
        }
        return this.transportLayer.ready();
    }

    public boolean ready() {
        return this.transportLayer.ready() && this.authenticator.complete();
    }

    public boolean hasSend() {
        return this.send != null;
    }

    public InetAddress socketAddress() {
        return this.transportLayer.socketChannel().socket().getInetAddress();
    }

    public String socketDescription() {
        Socket socket = this.transportLayer.socketChannel().socket();
        if (socket.getInetAddress() == null) {
            return socket.getLocalAddress().toString();
        }
        return socket.getInetAddress().toString();
    }

    public void setSend(Send send) {
        if (this.send != null) {
            throw new IllegalStateException("Attempt to begin a send operation with prior send operation still in progress, connection id is " + this.id);
        }
        this.send = send;
        this.transportLayer.addInterestOps(4);
    }

    public NetworkReceive read() throws IOException {
        NetworkReceive result2 = null;
        if (this.receive == null) {
            this.receive = new NetworkReceive(this.maxReceiveSize, this.id, this.memoryPool);
        }
        this.receive(this.receive);
        if (this.receive.complete()) {
            this.receive.payload().rewind();
            result2 = this.receive;
            this.receive = null;
        } else if (this.receive.requiredMemoryAmountKnown() && !this.receive.memoryAllocated() && this.isInMutableState()) {
            this.mute();
        }
        return result2;
    }

    public Send write() throws IOException {
        Send result2 = null;
        if (this.send != null && this.send(this.send)) {
            result2 = this.send;
            this.send = null;
        }
        return result2;
    }

    public void addNetworkThreadTimeNanos(long nanos) {
        this.networkThreadTimeNanos += nanos;
    }

    public long getAndResetNetworkThreadTimeNanos() {
        long current = this.networkThreadTimeNanos;
        this.networkThreadTimeNanos = 0L;
        return current;
    }

    private long receive(NetworkReceive receive) throws IOException {
        return receive.readFrom(this.transportLayer);
    }

    private boolean send(Send send) throws IOException {
        send.writeTo(this.transportLayer);
        if (send.completed()) {
            this.transportLayer.removeInterestOps(4);
        }
        return send.completed();
    }

    public boolean hasBytesBuffered() {
        return this.transportLayer.hasBytesBuffered();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaChannel that = (KafkaChannel)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static enum ChannelMuteEvent {
        REQUEST_RECEIVED,
        RESPONSE_SENT,
        THROTTLE_STARTED,
        THROTTLE_ENDED;

    }

    public static enum ChannelMuteState {
        NOT_MUTED,
        MUTED,
        MUTED_AND_RESPONSE_PENDING,
        MUTED_AND_THROTTLED,
        MUTED_AND_THROTTLED_AND_RESPONSE_PENDING;

    }
}

