/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.grpc.okhttp;

import com.clickhouse.client.internal.grpc.internal.WritableBuffer;
import com.clickhouse.client.internal.okio.Buffer;

class OkHttpWritableBuffer
implements WritableBuffer {
    private final Buffer buffer;
    private int writableBytes;
    private int readableBytes;

    OkHttpWritableBuffer(Buffer buffer, int capacity) {
        this.buffer = buffer;
        this.writableBytes = capacity;
    }

    @Override
    public void write(byte[] src, int srcIndex, int length) {
        this.buffer.write(src, srcIndex, length);
        this.writableBytes -= length;
        this.readableBytes += length;
    }

    @Override
    public void write(byte b) {
        this.buffer.writeByte(b);
        --this.writableBytes;
        ++this.readableBytes;
    }

    @Override
    public int writableBytes() {
        return this.writableBytes;
    }

    @Override
    public int readableBytes() {
        return this.readableBytes;
    }

    @Override
    public void release() {
    }

    Buffer buffer() {
        return this.buffer;
    }
}

