/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ratis.datastream.impl.DataStreamReplyByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestFilePositionCount;
import org.apache.ratis.io.FilePositionCount;
import org.apache.ratis.io.StandardWriteOption;
import org.apache.ratis.io.WriteOption;
import org.apache.ratis.netty.server.DataStreamRequestByteBuf;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.DataStreamPacketHeader;
import org.apache.ratis.protocol.DataStreamReplyHeader;
import org.apache.ratis.protocol.DataStreamRequest;
import org.apache.ratis.protocol.DataStreamRequestHeader;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;
import org.apache.ratis.thirdparty.io.netty.channel.DefaultFileRegion;

public interface NettyDataStreamUtils {
    public static ByteBuffer getDataStreamRequestHeaderProtoByteBuffer(DataStreamRequest request) {
        RaftProtos.DataStreamPacketHeaderProto.Builder b = RaftProtos.DataStreamPacketHeaderProto.newBuilder().setClientId(request.getClientId().toByteString()).setStreamId(request.getStreamId()).setStreamOffset(request.getStreamOffset()).setType(request.getType()).setDataLength(request.getDataLength());
        for (WriteOption option : request.getWriteOptions()) {
            b.addOptions(RaftProtos.DataStreamPacketHeaderProto.Option.forNumber((int)((StandardWriteOption)option).ordinal()));
        }
        return RaftProtos.DataStreamRequestHeaderProto.newBuilder().setPacketHeader(b).build().toByteString().asReadOnlyByteBuffer();
    }

    public static ByteBuffer getDataStreamReplyHeaderProtoByteBuf(DataStreamReplyByteBuffer reply) {
        RaftProtos.DataStreamPacketHeaderProto.Builder b = RaftProtos.DataStreamPacketHeaderProto.newBuilder().setClientId(reply.getClientId().toByteString()).setStreamId(reply.getStreamId()).setStreamOffset(reply.getStreamOffset()).setType(reply.getType()).setDataLength(reply.getDataLength());
        return RaftProtos.DataStreamReplyHeaderProto.newBuilder().setPacketHeader(b).setBytesWritten(reply.getBytesWritten()).setSuccess(reply.isSuccess()).build().toByteString().asReadOnlyByteBuffer();
    }

    public static void encodeDataStreamRequestHeader(DataStreamRequest request, Consumer<Object> out, ByteBufAllocator allocator) {
        ByteBuffer headerBuf = NettyDataStreamUtils.getDataStreamRequestHeaderProtoByteBuffer(request);
        ByteBuf headerBodyLenBuf = allocator.directBuffer(DataStreamPacketHeader.getSizeOfHeaderBodyLen());
        headerBodyLenBuf.writeLong((long)headerBuf.remaining() + request.getDataLength());
        out.accept(headerBodyLenBuf);
        ByteBuf headerLenBuf = allocator.directBuffer(DataStreamPacketHeader.getSizeOfHeaderLen());
        headerLenBuf.writeInt(headerBuf.remaining());
        out.accept(headerLenBuf);
        out.accept(Unpooled.wrappedBuffer((ByteBuffer)headerBuf));
    }

    public static void encodeDataStreamRequestByteBuffer(DataStreamRequestByteBuffer request, Consumer<Object> out, ByteBufAllocator allocator) {
        NettyDataStreamUtils.encodeDataStreamRequestHeader((DataStreamRequest)request, out, allocator);
        out.accept(Unpooled.wrappedBuffer((ByteBuffer)request.slice()));
    }

    public static void encodeDataStreamRequestFilePositionCount(DataStreamRequestFilePositionCount request, Consumer<Object> out, ByteBufAllocator allocator) {
        NettyDataStreamUtils.encodeDataStreamRequestHeader((DataStreamRequest)request, out, allocator);
        FilePositionCount f = request.getFile();
        out.accept(new DefaultFileRegion(f.getFile(), f.getPosition(), f.getCount()));
    }

    public static void encodeDataStreamReplyByteBuffer(DataStreamReplyByteBuffer reply, Consumer<ByteBuf> out, ByteBufAllocator allocator) {
        ByteBuffer headerBuf = NettyDataStreamUtils.getDataStreamReplyHeaderProtoByteBuf(reply);
        ByteBuf headerLenBuf = allocator.directBuffer(DataStreamPacketHeader.getSizeOfHeaderLen());
        headerLenBuf.writeInt(headerBuf.remaining());
        out.accept(headerLenBuf);
        out.accept(Unpooled.wrappedBuffer((ByteBuffer)headerBuf));
        out.accept(Unpooled.wrappedBuffer((ByteBuffer)reply.slice()));
    }

    public static DataStreamRequestByteBuf decodeDataStreamRequestByteBuf(ByteBuf buf) {
        return Optional.ofNullable(DataStreamRequestHeader.read((ByteBuf)buf)).map(header -> NettyDataStreamUtils.checkHeader(header, buf)).map(header -> new DataStreamRequestByteBuf((DataStreamRequestHeader)header, NettyDataStreamUtils.decodeData(buf, (DataStreamPacketHeader)header, ByteBuf::retain))).orElse(null);
    }

    public static ByteBuffer copy(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return ByteBuffer.wrap(bytes);
    }

    public static DataStreamReplyByteBuffer decodeDataStreamReplyByteBuffer(ByteBuf buf) {
        return Optional.ofNullable(DataStreamReplyHeader.read((ByteBuf)buf)).map(header -> NettyDataStreamUtils.checkHeader(header, buf)).map(header -> DataStreamReplyByteBuffer.newBuilder().setDataStreamReplyHeader(header).setBuffer(NettyDataStreamUtils.decodeData(buf, (DataStreamPacketHeader)header, NettyDataStreamUtils::copy)).build()).orElse(null);
    }

    public static <HEADER extends DataStreamPacketHeader> HEADER checkHeader(HEADER header, ByteBuf buf) {
        if (header == null) {
            return null;
        }
        if ((long)buf.readableBytes() < header.getDataLength()) {
            buf.resetReaderIndex();
            return null;
        }
        return header;
    }

    public static <DATA> DATA decodeData(ByteBuf buf, DataStreamPacketHeader header, Function<ByteBuf, DATA> toData) {
        DATA data;
        int dataLength = Math.toIntExact(header.getDataLength());
        if (dataLength > 0) {
            data = toData.apply(buf.slice(buf.readerIndex(), dataLength));
            buf.readerIndex(buf.readerIndex() + dataLength);
        } else {
            data = null;
        }
        buf.markReaderIndex();
        return data;
    }
}

