/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.server.management.plugin.servlet.query.ConfiguredObjectQuery;
import org.apache.qpid.server.management.plugin.servlet.query.EvaluationException;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryServlet<X extends ConfiguredObject<?>>
extends AbstractServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryServlet.class);

    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.performQuery(request, response);
    }

    @Override
    protected void doPostWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.performQuery(request, response);
    }

    private void performQuery(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String categoryName;
        X parent = this.getParent(request);
        if (parent != null && (categoryName = this.getRequestedCategory(request)) != null) {
            Model model = parent.getModel();
            Class<ConfiguredObject> category = this.getSupportedCategory(categoryName, model);
            if (category != null) {
                List<ConfiguredObject<?>> objects = this.getAllObjects(parent, category, request);
                LinkedHashMap<String, Object> resultsObject = new LinkedHashMap<String, Object>();
                try {
                    ConfiguredObjectQuery query = new ConfiguredObjectQuery(objects, request.getParameter("select"), request.getParameter("where"), request.getParameter("orderBy"), request.getParameter("limit"), request.getParameter("offset"));
                    resultsObject.put("headers", query.getHeaders());
                    resultsObject.put("results", query.getResults());
                    resultsObject.put("total", query.getTotalNumberOfRows());
                    this.sendJsonResponse(resultsObject, request, response);
                }
                catch (SelectorParsingException e) {
                    this.sendJsonErrorResponse(request, response, 400, e.getMessage());
                }
                catch (EvaluationException e) {
                    this.sendJsonErrorResponse(request, response, 422, e.getMessage());
                }
            } else {
                this.sendJsonErrorResponse(request, response, 404, "Unknown object type " + categoryName);
            }
        } else {
            this.sendJsonErrorResponse(request, response, 404, "Invalid path");
        }
    }

    protected abstract X getParent(HttpServletRequest var1);

    protected abstract Class<? extends ConfiguredObject> getSupportedCategory(String var1, Model var2);

    protected abstract String getRequestedCategory(HttpServletRequest var1);

    protected abstract List<ConfiguredObject<?>> getAllObjects(X var1, Class<? extends ConfiguredObject> var2, HttpServletRequest var3);
}

