/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.GunzipOutputStream;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.eclipse.jetty.io.EofException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServlet
extends HttpServlet {
    public static final int SC_UNPROCESSABLE_ENTITY = 422;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServlet.class);
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    private Broker<?> _broker;
    private HttpManagementConfiguration _managementConfiguration;

    protected AbstractServlet() {
    }

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        this._broker = HttpManagementUtil.getBroker(servletContext);
        this._managementConfiguration = HttpManagementUtil.getManagementConfiguration(servletContext);
        super.init();
    }

    protected final void doGet(final HttpServletRequest request, final HttpServletResponse resp) throws ServletException, IOException {
        this.doWithSubjectAndActor(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractServlet.this.doGetWithSubjectAndActor(request, resp);
                return null;
            }
        }, request, resp);
    }

    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        throw new UnsupportedOperationException("GET not supported by this servlet");
    }

    protected final void doPost(final HttpServletRequest request, final HttpServletResponse resp) throws ServletException, IOException {
        this.doWithSubjectAndActor(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractServlet.this.doPostWithSubjectAndActor(request, resp);
                return null;
            }
        }, request, resp);
    }

    protected void doPostWithSubjectAndActor(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new UnsupportedOperationException("POST not supported by this servlet");
    }

    protected final void doPut(final HttpServletRequest request, final HttpServletResponse resp) throws ServletException, IOException {
        this.doWithSubjectAndActor(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractServlet.this.doPutWithSubjectAndActor(request, resp);
                return null;
            }
        }, request, resp);
    }

    public OutputStream getOutputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return HttpManagementUtil.getOutputStream(request, response, this._managementConfiguration);
    }

    protected void doPutWithSubjectAndActor(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new UnsupportedOperationException("PUT not supported by this servlet");
    }

    protected final void doDelete(final HttpServletRequest request, final HttpServletResponse resp) throws ServletException, IOException {
        this.doWithSubjectAndActor(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AbstractServlet.this.doDeleteWithSubjectAndActor(request, resp);
                return null;
            }
        }, request, resp);
    }

    protected void doDeleteWithSubjectAndActor(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new UnsupportedOperationException("DELETE not supported by this servlet");
    }

    private void doWithSubjectAndActor(PrivilegedExceptionAction<Void> privilegedExceptionAction, HttpServletRequest request, HttpServletResponse resp) throws IOException {
        Subject subject;
        try {
            subject = this.getAuthorisedSubject(request);
        }
        catch (SecurityException e) {
            this.sendError(resp, 401);
            return;
        }
        try {
            Subject.doAs(subject, privilegedExceptionAction);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EofException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new ConnectionScopedRuntimeException(e.getCause());
        }
    }

    protected Subject getAuthorisedSubject(HttpServletRequest request) {
        Subject subject = HttpManagementUtil.getAuthorisedSubject(request);
        if (subject == null) {
            throw new SecurityException("Access to management rest interfaces is denied for un-authorised user");
        }
        return subject;
    }

    protected Broker<?> getBroker() {
        return this._broker;
    }

    protected HttpManagementConfiguration getManagementConfiguration() {
        return this._managementConfiguration;
    }

    protected void sendJsonResponse(Object object, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.sendJsonResponse(object, request, response, 200, true);
    }

    protected final void sendJsonResponse(Object object, HttpServletRequest request, HttpServletResponse response, int responseCode, boolean sendCachingHeaders) throws IOException {
        response.setStatus(responseCode);
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (sendCachingHeaders) {
            this.sendCachingHeadersOnResponse(response);
        }
        if (object instanceof CustomRestHeaders) {
            this.setResponseHeaders(response, (CustomRestHeaders)object);
        }
        this.writeObjectToResponse(object, request, response);
    }

    protected final void sendJsonErrorResponse(HttpServletRequest request, HttpServletResponse response, int responseCode, String message) throws IOException {
        this.sendJsonResponse(Collections.singletonMap("errorMessage", message), request, response, responseCode, false);
    }

    protected void sendError(HttpServletResponse resp, int responseCode) {
        try {
            resp.sendError(responseCode);
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException("Failed to send error response code " + responseCode, (Throwable)e);
        }
    }

    private void writeObjectToResponse(Object object, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OutputStream stream = this.getOutputStream(request, response);
        ObjectMapper mapper = ConfiguredObjectJacksonModule.newObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.writeValue(stream, object);
    }

    protected void sendCachingHeadersOnResponse(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    protected void writeTypedContent(Content content, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map<String, Object> headers = this.getResponseHeaders(content);
        try (OutputStream os = this.getOutputStream(request, response, headers);){
            response.setStatus(200);
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                response.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
            content.write(os);
        }
        catch (IOException e) {
            LOGGER.warn("Unexpected exception processing request", (Throwable)e);
            this.sendJsonErrorResponse(request, response, 500, e.getMessage());
        }
    }

    private OutputStream getOutputStream(HttpServletRequest request, HttpServletResponse response, Map<String, Object> headers) throws IOException {
        boolean isGzipCompressed = "gzip".equals(headers.get("Content-Encoding".toUpperCase()));
        boolean isCompressingAccepted = HttpManagementUtil.isCompressingAccepted(request, this._managementConfiguration);
        Object stream = response.getOutputStream();
        if (isGzipCompressed) {
            if (!isCompressingAccepted) {
                stream = new GunzipOutputStream((OutputStream)stream);
                headers.remove("Content-Encoding".toUpperCase());
            }
        } else if (isCompressingAccepted) {
            stream = new GZIPOutputStream((OutputStream)stream);
            headers.put("Content-Encoding".toUpperCase(), "gzip");
        }
        return stream;
    }

    private Map<String, Object> getResponseHeaders(Object content) {
        CustomRestHeaders customRestHeaders;
        Map<RestContentHeader, Method> contentHeaderGetters;
        Map<String, Object> headers = Collections.emptyMap();
        if (content instanceof CustomRestHeaders && (contentHeaderGetters = this.getContentHeaderMethods(customRestHeaders = (CustomRestHeaders)content)) != null) {
            headers = new HashMap<String, Object>();
            for (Map.Entry<RestContentHeader, Method> entry : contentHeaderGetters.entrySet()) {
                String headerName = entry.getKey().value();
                try {
                    Object headerValue = entry.getValue().invoke((Object)customRestHeaders, new Object[0]);
                    if (headerValue == null) continue;
                    headers.put(headerName.toUpperCase(), headerValue);
                }
                catch (Exception e) {
                    LOGGER.warn("Unexpected exception whilst setting response header " + headerName, (Throwable)e);
                }
            }
        }
        return headers;
    }

    private void setResponseHeaders(HttpServletResponse response, CustomRestHeaders customRestHeaders) {
        Map<String, Object> headers = this.getResponseHeaders(customRestHeaders);
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            response.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    private Map<RestContentHeader, Method> getContentHeaderMethods(CustomRestHeaders content) {
        Method[] methods;
        HashMap<RestContentHeader, Method> results = new HashMap<RestContentHeader, Method>();
        for (Method method : methods = content.getClass().getMethods()) {
            if (!method.isAnnotationPresent(RestContentHeader.class)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length > 0) {
                LOGGER.warn("Parameters are found on method " + method.getName() + " annotated with ContentHeader annotation. No parameter is allowed. Ignoring ContentHeader annotation.");
                continue;
            }
            method.setAccessible(true);
            results.put(method.getAnnotation(RestContentHeader.class), method);
        }
        return results;
    }
}

