/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.report;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.management.plugin.report.QueueBinaryReport;
import org.apache.qpid.server.management.plugin.report.QueueReport;
import org.apache.qpid.server.management.plugin.report.ReportableMessage;
import org.apache.qpid.server.management.plugin.report.ReportableMessageHeader;
import org.apache.qpid.server.message.MessageInfoImpl;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.util.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportRunner<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportRunner.class);
    private static final Set<Class> IMMUTABLE_CLASSES = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, UUID.class, String.class));
    private final QueueReport<T> _report;

    private ReportRunner(QueueReport<T> report) {
        this._report = report;
    }

    public boolean isBinaryReport() {
        return this._report instanceof QueueBinaryReport;
    }

    public static ReportRunner<?> createRunner(String reportName, Map<String, String[]> parameterMap) {
        QueueReport<?> report = ReportRunner.getReport(reportName);
        ReportRunner.setReportParameters(report, parameterMap);
        return new ReportRunner(report);
    }

    private static void setReportParameters(QueueReport<?> report, Map<String, String[]> parameterMap) {
        if (parameterMap != null && !parameterMap.isEmpty()) {
            Class<?> clazz = report.getClass();
            for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                String key = entry.getKey();
                String[] value = entry.getValue();
                if (ReportRunner.isValidName(key)) {
                    StringBuilder setterName = new StringBuilder("set");
                    setterName.append(key.substring(0, 1).toUpperCase());
                    if (key.length() > 1) {
                        setterName.append(key.substring(1));
                    }
                    Method method = null;
                    try {
                        if (value == null || value.length == 0 || value.length == 1) {
                            try {
                                method = clazz.getMethod(setterName.toString(), String.class);
                                method.invoke(report, value == null || value.length == 0 ? null : value[0]);
                            }
                            catch (IllegalAccessException | NoSuchMethodException e) {
                                method = null;
                            }
                        }
                        if (method != null) continue;
                        try {
                            method = clazz.getMethod(setterName.toString(), String[].class);
                            method.invoke(report, new Object[]{value});
                        }
                        catch (IllegalAccessException | NoSuchMethodException e) {
                            LOGGER.info("Unknown parameter '" + key + "' (no setter) for report " + report.getName());
                        }
                    }
                    catch (InvocationTargetException e) {
                        LOGGER.info("Error setting parameter '" + key + "' for report " + report.getName(), (Throwable)e);
                    }
                    continue;
                }
                LOGGER.info("Invalid parameter name '" + key + "' running report " + report.getName());
            }
        }
    }

    private static boolean isValidName(String key) {
        if (key != null && key.length() != 0 && Character.isJavaIdentifierStart(key.charAt(0))) {
            for (int i = 1; i < key.length(); ++i) {
                if (Character.isJavaIdentifierPart(key.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static QueueReport<?> getReport(String reportName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (QueueReport report : ServiceLoader.load(QueueReport.class, classLoader)) {
            if (!report.getName().equals(reportName)) continue;
            try {
                return (QueueReport)report.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            }
        }
        throw new IllegalArgumentException("Unknown report: " + reportName);
    }

    public String getContentType() {
        return this._report.getContentType();
    }

    private static ReportableMessage convertMessage(QueueEntry entry) {
        final MessageInfoImpl messageInfo = new MessageInfoImpl((MessageInstance)entry, true);
        ServerMessage message = entry.getMessage();
        Collection contentBuffers = message.getContent(0, (int)message.getSize());
        final ByteBuffer content = ByteBufferUtils.combine((Collection)contentBuffers);
        for (QpidByteBuffer buf : contentBuffers) {
            buf.dispose();
        }
        return new ReportableMessage(){

            @Override
            public String getInitialRoutingAddress() {
                return messageInfo.getInitialRoutingAddress();
            }

            @Override
            public ReportableMessageHeader getMessageHeader() {
                return ReportRunner.convertMessageHeader(messageInfo);
            }

            @Override
            public ByteBuffer getContent() {
                return content.asReadOnlyBuffer();
            }

            @Override
            public boolean isPersistent() {
                return messageInfo.isPersistent();
            }

            @Override
            public long getSize() {
                return messageInfo.getSize();
            }

            @Override
            public Date getExpiration() {
                return messageInfo.getExpirationTime();
            }

            @Override
            public long getMessageNumber() {
                return messageInfo.getId();
            }

            @Override
            public Date getArrivalTime() {
                return messageInfo.getArrivalTime();
            }
        };
    }

    private static ReportableMessageHeader convertMessageHeader(final MessageInfoImpl messageInfo) {
        return new ReportableMessageHeader(){

            @Override
            public String getCorrelationId() {
                return messageInfo.getCorrelationId();
            }

            @Override
            public Date getExpiration() {
                return messageInfo.getExpirationTime();
            }

            @Override
            public String getUserId() {
                return messageInfo.getUserId();
            }

            @Override
            public String getAppId() {
                return messageInfo.getApplicationId();
            }

            @Override
            public String getMessageId() {
                return messageInfo.getMessageId();
            }

            @Override
            public String getMimeType() {
                return messageInfo.getMimeType();
            }

            @Override
            public String getEncoding() {
                return messageInfo.getEncoding();
            }

            @Override
            public byte getPriority() {
                return (byte)messageInfo.getPriority();
            }

            @Override
            public Date getTimestamp() {
                return messageInfo.getTimestamp();
            }

            @Override
            public String getType() {
                return messageInfo.getType();
            }

            @Override
            public String getReplyTo() {
                return messageInfo.getReplyTo();
            }

            @Override
            public Object getHeader(String name) {
                return ReportRunner.makeImmutable(messageInfo.getHeaders().get(name));
            }

            @Override
            public boolean containsHeaders(Set<String> names) {
                return messageInfo.getHeaders().keySet().contains(names);
            }

            @Override
            public boolean containsHeader(String name) {
                return messageInfo.getHeaders().containsKey(name);
            }

            @Override
            public Collection<String> getHeaderNames() {
                return Collections.unmodifiableCollection(messageInfo.getHeaders().keySet());
            }
        };
    }

    private static Object makeImmutable(Object value) {
        if (value == null || IMMUTABLE_CLASSES.contains(value.getClass())) {
            return value;
        }
        if (value instanceof byte[]) {
            return ByteBuffer.wrap((byte[])value).asReadOnlyBuffer();
        }
        if (value instanceof List) {
            List orig = (List)value;
            ArrayList<Object> copy = new ArrayList<Object>(orig.size());
            for (Object element : orig) {
                copy.add(ReportRunner.makeImmutable(element));
            }
            return copy;
        }
        if (value instanceof Map) {
            Map orig = (Map)value;
            LinkedHashMap<Object, Object> copy = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : orig.entrySet()) {
                copy.put(ReportRunner.makeImmutable(entry.getKey()), ReportRunner.makeImmutable(entry.getValue()));
            }
            return copy;
        }
        if (value instanceof Date) {
            return new Date(((Date)value).getTime());
        }
        return null;
    }

    public final T runReport(Queue<?> queue) {
        this._report.setQueue(queue);
        ReportVisitor visitor = new ReportVisitor(this._report);
        queue.visit((QueueEntryVisitor)visitor);
        return this._report.getReport();
    }

    private static class ReportVisitor
    implements QueueEntryVisitor {
        private final QueueReport _report;

        public ReportVisitor(QueueReport report) {
            this._report = report;
        }

        public boolean visit(QueueEntry entry) {
            this._report.addMessage(ReportRunner.convertMessage(entry));
            return this._report.isComplete();
        }
    }
}

