/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import org.apache.qpid.server.flow.AbstractFlowCreditManager;
import org.apache.qpid.server.protocol.v0_10.FlowCreditManager_0_10;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowCreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager_0_10 {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowCreditManager.class);
    private final ProtocolEngine _protocolEngine;
    private volatile long _bytesCreditLimit;
    private volatile long _messageCreditLimit;
    private volatile long _bytesUsed;
    private volatile long _messageUsed;

    public WindowCreditManager(long bytesCreditLimit, long messageCreditLimit, ProtocolEngine protocolEngine) {
        this._protocolEngine = protocolEngine;
        this._bytesCreditLimit = bytesCreditLimit;
        this._messageCreditLimit = messageCreditLimit;
        this.setSuspended(!this.hasCredit());
    }

    public synchronized long getMessageCreditLimit() {
        return this._messageCreditLimit;
    }

    synchronized long getMessageCredit() {
        return this._messageCreditLimit == -1L ? Long.MAX_VALUE : (this._messageUsed < this._messageCreditLimit ? this._messageCreditLimit - this._messageUsed : 0L);
    }

    synchronized long getBytesCredit() {
        return this._bytesCreditLimit == -1L ? Long.MAX_VALUE : (this._bytesUsed < this._bytesCreditLimit ? this._bytesCreditLimit - this._bytesUsed : 0L);
    }

    public synchronized void restoreCredit(long messageCredit, long bytesCredit) {
        this._messageUsed -= messageCredit;
        if (this._messageUsed < 0L) {
            LOGGER.error("Message credit used value was negative: " + this._messageUsed);
            this._messageUsed = 0L;
        }
        boolean notifyIncrease = true;
        if (this._messageCreditLimit > 0L) {
            notifyIncrease = this._messageUsed != this._messageCreditLimit;
        }
        this._bytesUsed -= bytesCredit;
        if (this._bytesUsed < 0L) {
            LOGGER.error("Bytes credit used value was negative: " + this._bytesUsed);
            this._bytesUsed = 0L;
        }
        notifyIncrease = notifyIncrease && bytesCredit > 0L && this._bytesCreditLimit > 0L;
        if (!this.setSuspended(!this.hasCredit()) && notifyIncrease) {
            this.notifyIncreaseBytesCredit();
        }
    }

    public synchronized boolean hasCredit() {
        return !(this._bytesCreditLimit >= 0L && this._bytesCreditLimit <= this._bytesUsed || this._messageCreditLimit >= 0L && this._messageCreditLimit <= this._messageUsed || this._protocolEngine.isTransportBlockedForWriting());
    }

    public synchronized boolean useCreditForMessage(long msgSize) {
        if (this._protocolEngine.isTransportBlockedForWriting()) {
            this.setSuspended(true);
            return false;
        }
        if (this._messageCreditLimit >= 0L) {
            if (this._messageUsed < this._messageCreditLimit) {
                if (this._bytesCreditLimit < 0L) {
                    ++this._messageUsed;
                    return true;
                }
                if (this._bytesUsed + msgSize <= this._bytesCreditLimit) {
                    ++this._messageUsed;
                    this._bytesUsed += msgSize;
                    return true;
                }
                return false;
            }
            this.setSuspended(true);
            return false;
        }
        if (this._bytesCreditLimit >= 0L) {
            if (this._bytesUsed + msgSize <= this._bytesCreditLimit) {
                this._bytesUsed += msgSize;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized void addCredit(long count, long bytes) {
        if (bytes > 0L) {
            this._bytesCreditLimit += bytes;
        } else if (bytes == -1L) {
            this._bytesCreditLimit = -1L;
        }
        if (count > 0L) {
            this._messageCreditLimit += count;
        } else if (count == -1L) {
            this._messageCreditLimit = -1L;
        }
    }

    @Override
    public synchronized void clearCredit() {
        this._bytesCreditLimit = 0L;
        this._messageCreditLimit = 0L;
        this.setSuspended(true);
    }
}

