/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_10.ServerAssembler;
import org.apache.qpid.server.protocol.v0_10.ServerFrame;
import org.apache.qpid.transport.FrameSizeObserver;
import org.apache.qpid.transport.ProtocolError;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.SegmentType;
import org.apache.qpid.transport.util.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInputHandler
implements FrameSizeObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerInputHandler.class);
    private static final QpidByteBuffer EMPTY_BYTE_BUFFER = QpidByteBuffer.allocateDirect((int)0);
    private int _maxFrameSize = 4096;
    private final ServerAssembler _serverAssembler;
    private State _state = State.PROTO_HDR;
    private byte flags;
    private SegmentType type;
    private byte track;
    private int channel;

    public ServerInputHandler(ServerAssembler serverAssembler) {
        this._serverAssembler = serverAssembler;
        this._state = State.PROTO_HDR;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this._maxFrameSize = maxFrameSize;
    }

    private void error(String fmt, Object ... args) {
        this._serverAssembler.error(new ProtocolError(0, fmt, args));
    }

    public void received(QpidByteBuffer buf) {
        int position = buf.position();
        while (buf.hasRemaining() && this._state != State.ERROR) {
            this.parse(buf);
            int newPosition = buf.position();
            if (position == newPosition) break;
            position = newPosition;
        }
    }

    private void parse(QpidByteBuffer buffer) {
        buffer.mark();
        switch (this._state) {
            case PROTO_HDR: {
                if (buffer.remaining() < 8) break;
                if (buffer.get() != 65 || buffer.get() != 77 || buffer.get() != 81 || buffer.get() != 80) {
                    buffer.reset();
                    this.error("bad protocol header: %s", Functions.str((QpidByteBuffer)buffer));
                    this._state = State.ERROR;
                    break;
                }
                byte protoClass = buffer.get();
                byte instance = buffer.get();
                byte major = buffer.get();
                byte minor = buffer.get();
                this._serverAssembler.init(new ProtocolHeader(protoClass, instance, major, minor));
                this._state = State.FRAME_HDR;
                break;
            }
            case FRAME_HDR: {
                if (buffer.remaining() < 12) {
                    buffer.reset();
                    break;
                }
                this.flags = buffer.get();
                this.type = SegmentType.get((short)buffer.get());
                int size = 0xFFFF & buffer.getShort();
                if ((size -= 12) < 0 || size > this._maxFrameSize - 12) {
                    this.error("bad frame size: %d", size);
                    this._state = State.ERROR;
                    break;
                }
                buffer.get();
                byte b = buffer.get();
                if ((b & 0xF0) != 0) {
                    this.error("non-zero reserved bits in upper nibble of frame header byte 5: '%x'", b);
                    this._state = State.ERROR;
                    break;
                }
                this.track = (byte)(b & 0xF);
                this.channel = 0xFFFF & buffer.getShort();
                buffer.position(buffer.position() + 4);
                if (size == 0) {
                    ServerFrame frame = new ServerFrame(this.flags, this.type, this.track, this.channel, EMPTY_BYTE_BUFFER.duplicate());
                    this._serverAssembler.received(frame);
                    break;
                }
                if (buffer.remaining() < size) {
                    buffer.reset();
                    break;
                }
                QpidByteBuffer body = buffer.slice();
                body.limit(size);
                ServerFrame frame = new ServerFrame(this.flags, this.type, this.track, this.channel, body);
                buffer.position(buffer.position() + size);
                this._serverAssembler.received(frame);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void exception(Throwable t) {
        this._serverAssembler.exception(t);
    }

    public void closed() {
        this._serverAssembler.closed();
    }

    public static enum State {
        PROTO_HDR,
        FRAME_HDR,
        ERROR;

    }
}

