/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.configuration.CommonProperties;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.protocol.v0_10.AMQPConnection_0_10;
import org.apache.qpid.server.protocol.v0_10.ConsumerTarget_0_10;
import org.apache.qpid.server.protocol.v0_10.ServerConnection;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.protocol.v0_10.ServerSessionDelegate;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.virtualhost.VirtualHostUnavailableException;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionClose;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.ConnectionOpen;
import org.apache.qpid.transport.ConnectionOpenOk;
import org.apache.qpid.transport.ConnectionRedirect;
import org.apache.qpid.transport.ConnectionSecureOk;
import org.apache.qpid.transport.ConnectionStartOk;
import org.apache.qpid.transport.ConnectionTuneOk;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.ServerDelegate;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionAttach;
import org.apache.qpid.transport.SessionDetach;
import org.apache.qpid.transport.SessionDetachCode;
import org.apache.qpid.transport.SessionDetached;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectionDelegate
extends ServerDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConnectionDelegate.class);
    private final Broker _broker;
    private final String _localFQDN;
    private int _maxNoOfChannels;
    private Map<String, Object> _clientProperties;
    private final SubjectCreator _subjectCreator;
    private int _maximumFrameSize;
    private boolean _compressionSupported;
    private volatile ConnectionState _state = ConnectionState.INIT;
    private volatile SubjectAuthenticationResult _successfulAuthenticationResult;

    public ServerConnectionDelegate(Broker<?> broker, String localFQDN, SubjectCreator subjectCreator) {
        this(ServerConnectionDelegate.createConnectionProperties(broker), Collections.singletonList("en_US"), broker, localFQDN, subjectCreator);
    }

    private ServerConnectionDelegate(Map<String, Object> properties, List<Object> locales, Broker<?> broker, String localFQDN, SubjectCreator subjectCreator) {
        super(properties, subjectCreator.getMechanisms(), locales);
        this._broker = broker;
        this._localFQDN = localFQDN;
        this._maxNoOfChannels = broker.getConnection_sessionCountLimit();
        this._subjectCreator = subjectCreator;
        this._maximumFrameSize = Math.min(65535, broker.getNetworkBufferSize());
    }

    public final ConnectionState getState() {
        return this._state;
    }

    private void assertState(ServerConnection conn, ConnectionState requiredState) {
        if (this._state != requiredState) {
            String replyText = "Command Invalid, expected " + (Object)((Object)requiredState) + " but was " + (Object)((Object)this._state);
            conn.sendConnectionClose(ConnectionCloseCode.FRAMING_ERROR, replyText, new Option[0]);
            conn.closeAndIgnoreFutureInput();
            throw new ConnectionScopedRuntimeException(replyText);
        }
    }

    public void init(Connection conn, ProtocolHeader hdr) {
        this.assertState((ServerConnection)conn, ConnectionState.INIT);
        super.init(conn, hdr);
        this._state = ConnectionState.AWAIT_START_OK;
    }

    private static List<String> getFeatures(Broker<?> broker) {
        String brokerDisabledFeatures = System.getProperty("qpid.broker_disabled_features");
        ArrayList<String> features = new ArrayList<String>();
        if (brokerDisabledFeatures == null || !brokerDisabledFeatures.contains("qpid.jms-selector")) {
            features.add("qpid.jms-selector");
        }
        return Collections.unmodifiableList(features);
    }

    private static Map<String, Object> createConnectionProperties(Broker<?> broker) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("qpid.federation_tag", broker.getId().toString());
        List<String> features = ServerConnectionDelegate.getFeatures(broker);
        if (features != null && features.size() > 0) {
            map.put("qpid.features", features);
        }
        map.put("product", CommonProperties.getProductName());
        map.put("version", CommonProperties.getReleaseVersion());
        map.put("qpid.build", CommonProperties.getBuildVersion());
        map.put("qpid.instance_name", broker.getName());
        map.put("qpid.message_compression_supported", String.valueOf(broker.isMessageCompressionEnabled()));
        map.put("qpid.virtualhost_properties_supported", String.valueOf(broker.isVirtualHostPropertiesNodeEnabled()));
        map.put("qpid.queue_lifetime_supported", Boolean.TRUE.toString());
        return map;
    }

    public ServerSession getSession(Connection conn, SessionAttach atc) {
        ServerSessionDelegate serverSessionDelegate = new ServerSessionDelegate();
        ServerSession ssn = new ServerSession(conn, serverSessionDelegate, new Binary(atc.getName()), 0L);
        return ssn;
    }

    protected SaslServer createSaslServer(Connection conn, String mechanism) throws SaslException {
        return this._subjectCreator.createSaslServer(mechanism, this._localFQDN, ((ServerConnection)conn).getPeerPrincipal());
    }

    public void connectionSecureOk(Connection conn, ConnectionSecureOk ok) {
        this.assertState((ServerConnection)conn, ConnectionState.AWAIT_SECURE_OK);
        super.connectionSecureOk(conn, ok);
    }

    protected void secure(SaslServer ss, Connection conn, byte[] response) {
        ServerConnection sconn = (ServerConnection)conn;
        SubjectAuthenticationResult authResult = this._successfulAuthenticationResult;
        byte[] challenge = null;
        if (authResult == null) {
            authResult = this._subjectCreator.authenticate(ss, response);
            challenge = authResult.getChallenge();
        }
        if (AuthenticationResult.AuthenticationStatus.SUCCESS.equals((Object)authResult.getStatus())) {
            this._successfulAuthenticationResult = authResult;
            if (challenge == null || challenge.length == 0) {
                this.tuneAuthorizedConnection(sconn);
                sconn.setAuthorizedSubject(authResult.getSubject());
                this._state = ConnectionState.AWAIT_TUNE_OK;
            } else {
                this.connectionAuthContinue(sconn, authResult.getChallenge());
                this._state = ConnectionState.AWAIT_SECURE_OK;
            }
        } else if (AuthenticationResult.AuthenticationStatus.CONTINUE.equals((Object)authResult.getStatus())) {
            this.connectionAuthContinue(sconn, authResult.getChallenge());
            this._state = ConnectionState.AWAIT_SECURE_OK;
        } else {
            this.connectionAuthFailed(sconn, authResult.getCause());
        }
    }

    public void connectionClose(Connection conn, ConnectionClose close) {
        ServerConnection sconn = (ServerConnection)conn;
        sconn.closeCode(close);
        sconn.setState(Connection.State.CLOSE_RCVD);
        this.sendConnectionCloseOkAndCloseSender(conn);
    }

    public void connectionOpen(Connection conn, ConnectionOpen open) {
        ServerConnection sconn = (ServerConnection)conn;
        this.assertState(sconn, ConnectionState.AWAIT_OPEN);
        String vhostName = open.hasVirtualHost() ? open.getVirtualHost() : "";
        AmqpPort<?> port = sconn.getPort();
        NamedAddressSpace addressSpace = port.getAddressSpace(vhostName);
        if (addressSpace != null) {
            if (!addressSpace.isActive()) {
                sconn.setState(Connection.State.CLOSING);
                String redirectHost = addressSpace.getRedirectHost(port);
                if (redirectHost == null) {
                    sconn.sendConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, "Virtual host '" + vhostName + "' is not active", new Option[0]);
                } else {
                    sconn.invoke((Method)new ConnectionRedirect(redirectHost, new ArrayList(), new Option[0]));
                }
                return;
            }
            try {
                sconn.setVirtualHost(addressSpace);
                if (!addressSpace.authoriseCreateConnection((AMQPConnection)sconn.getAmqpConnection())) {
                    sconn.setState(Connection.State.CLOSING);
                    sconn.sendConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, "Connection not authorized", new Option[0]);
                    return;
                }
            }
            catch (AccessControlException | VirtualHostUnavailableException e) {
                sconn.setState(Connection.State.CLOSING);
                sconn.sendConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, e.getMessage(), new Option[0]);
                return;
            }
            sconn.setState(Connection.State.OPEN);
            this._state = ConnectionState.OPEN;
            sconn.invoke((Method)new ConnectionOpenOk(Collections.emptyList(), new Option[0]));
        } else {
            sconn.setState(Connection.State.CLOSING);
            sconn.sendConnectionClose(ConnectionCloseCode.INVALID_PATH, "Unknown virtualhost '" + vhostName + "'", new Option[0]);
        }
    }

    public void connectionTuneOk(Connection conn, ConnectionTuneOk ok) {
        ServerConnection sconn = (ServerConnection)conn;
        this.assertState(sconn, ConnectionState.AWAIT_TUNE_OK);
        int okChannelMax = ok.getChannelMax();
        int okMaxFrameSize = ok.getMaxFrameSize();
        if (okChannelMax > this.getChannelMax()) {
            LOGGER.error("Connection '" + sconn.getConnectionId() + "' being severed, " + "client connectionTuneOk returned a channelMax (" + okChannelMax + ") above the server's offered limit (" + this.getChannelMax() + ")");
            sconn.closeAndIgnoreFutureInput();
            return;
        }
        if (okMaxFrameSize > this.getFrameMax()) {
            LOGGER.error("Connection '" + sconn.getConnectionId() + "' being severed, " + "client connectionTuneOk returned a frameMax (" + okMaxFrameSize + ") above the server's offered limit (" + this.getFrameMax() + ")");
            sconn.closeAndIgnoreFutureInput();
            return;
        }
        if (okMaxFrameSize > 0 && okMaxFrameSize < 4096) {
            LOGGER.error("Connection '" + sconn.getConnectionId() + "' being severed, " + "client connectionTuneOk returned a frameMax (" + okMaxFrameSize + ") below the minimum permitted size (" + 4096 + ")");
            sconn.closeAndIgnoreFutureInput();
            return;
        }
        if (okMaxFrameSize == 0) {
            okMaxFrameSize = this.getFrameMax();
        }
        if (ok.hasHeartbeat() && ok.getHeartbeat() > 0) {
            int heartbeat = ok.getHeartbeat();
            long readerIdle = 2000L * (long)heartbeat;
            long writerIdle = 1000L * (long)heartbeat;
            sconn.getAmqpConnection().initialiseHeartbeating(writerIdle, readerIdle);
        }
        this.setConnectionTuneOkChannelMax(sconn, okChannelMax);
        conn.setMaxFrameSize(okMaxFrameSize);
        this._state = ConnectionState.AWAIT_OPEN;
    }

    public int getChannelMax() {
        return this._maxNoOfChannels;
    }

    protected void setChannelMax(int channelMax) {
        this._maxNoOfChannels = channelMax;
    }

    protected int getFrameMax() {
        return this._maximumFrameSize;
    }

    public void sessionDetach(Connection conn, SessionDetach dtc) {
        this.stopAllSubscriptions(conn, dtc);
        Session ssn = conn.getSession(dtc.getChannel());
        ((ServerSession)ssn).setClose(true);
        super.sessionDetach(conn, dtc);
    }

    private void stopAllSubscriptions(Connection conn, SessionDetach dtc) {
        ServerSession ssn = (ServerSession)conn.getSession(dtc.getChannel());
        Collection<ConsumerTarget_0_10> subs = ssn.getSubscriptions();
        for (ConsumerTarget_0_10 subscription_0_10 : subs) {
            subscription_0_10.stop();
        }
    }

    public void sessionAttach(Connection conn, SessionAttach atc) {
        this.assertState((ServerConnection)conn, ConnectionState.OPEN);
        if (this.isSessionNameUnique(atc.getName(), conn)) {
            super.sessionAttach(conn, atc);
        } else {
            ServerSession ssn = this.getSession(conn, atc);
            ssn.invoke((Method)new SessionDetached(atc.getName(), SessionDetachCode.SESSION_BUSY, new Option[0]));
            ssn.closed();
        }
    }

    private boolean isSessionNameUnique(byte[] name, Connection conn) {
        ServerConnection sconn = (ServerConnection)conn;
        Principal authorizedPrincipal = sconn.getAuthorizedPrincipal();
        String userId = authorizedPrincipal == null ? "" : authorizedPrincipal.getName();
        for (AMQPConnection amqConnectionModel : ((ServerConnection)conn).getAddressSpace().getConnections()) {
            String userName = amqConnectionModel.getAuthorizedPrincipal() == null ? "" : amqConnectionModel.getAuthorizedPrincipal().getName();
            if (!userId.equals(userName) || !amqConnectionModel.hasSessionWithName(name)) continue;
            return false;
        }
        return true;
    }

    public void connectionStartOk(Connection conn, ConnectionStartOk ok) {
        this.assertState((ServerConnection)conn, ConnectionState.AWAIT_START_OK);
        this._clientProperties = ok.getClientProperties();
        if (this._clientProperties != null) {
            Object compressionSupported = this._clientProperties.get("qpid.message_compression_supported");
            if (compressionSupported != null) {
                this._compressionSupported = Boolean.parseBoolean(String.valueOf(compressionSupported));
            }
            AMQPConnection_0_10 protocolEngine = ((ServerConnection)conn).getAmqpConnection();
            protocolEngine.setClientId(this.getStringClientProperty("clientName"));
            protocolEngine.setClientProduct(this.getStringClientProperty("product"));
            protocolEngine.setClientVersion(this.getStringClientProperty("qpid.client_version"));
            protocolEngine.setRemoteProcessPid(this.getStringClientProperty("qpid.client_pid"));
        }
        super.connectionStartOk(conn, ok);
    }

    private String getStringClientProperty(String name) {
        return this._clientProperties == null || this._clientProperties.get(name) == null ? null : String.valueOf(this._clientProperties.get(name));
    }

    public Map<String, Object> getClientProperties() {
        return this._clientProperties;
    }

    public String getClientId() {
        return this._clientProperties == null ? null : (String)this._clientProperties.get("clientName");
    }

    public String getClientVersion() {
        return this._clientProperties == null ? null : (String)this._clientProperties.get("qpid.client_version");
    }

    public String getClientProduct() {
        return this._clientProperties == null ? null : (String)this._clientProperties.get("product");
    }

    public String getRemoteProcessPid() {
        return this._clientProperties == null || this._clientProperties.get("qpid.client_pid") == null ? null : String.valueOf(this._clientProperties.get("qpid.client_pid"));
    }

    protected int getHeartbeatMax() {
        int delay = (Integer)this._broker.getAttribute("connection.heartBeatDelay");
        return delay == 0 ? super.getHeartbeatMax() : delay;
    }

    public boolean isCompressionSupported() {
        return this._compressionSupported && this._broker.isMessageCompressionEnabled();
    }

    static enum ConnectionState {
        INIT,
        AWAIT_START_OK,
        AWAIT_SECURE_OK,
        AWAIT_TUNE_OK,
        AWAIT_OPEN,
        OPEN;

    }
}

