/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.net.SocketAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.ConnectionClosingTicker;
import org.apache.qpid.server.protocol.v0_10.AMQPConnection_0_10;
import org.apache.qpid.server.protocol.v0_10.ServerConnectionDelegate;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionClose;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.ConnectionCloseOk;
import org.apache.qpid.transport.ExecutionErrorCode;
import org.apache.qpid.transport.ExecutionException;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolEvent;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.network.Ticker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnection
extends Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConnection.class);
    public static final long CLOSE_OK_TIMEOUT = 10000L;
    private final Broker<?> _broker;
    private final long _connectionId;
    private final Object _reference = new Object();
    private final AmqpPort<?> _port;
    private final AtomicLong _lastIoTime = new AtomicLong();
    private boolean _blocking;
    private final Transport _transport;
    private final Queue<Action<? super ServerConnection>> _asyncTaskList = new ConcurrentLinkedQueue<Action<? super ServerConnection>>();
    private final AMQPConnection_0_10 _amqpConnection;
    private boolean _ignoreFutureInput;
    private boolean _ignoreAllButConnectionCloseOk;

    public ServerConnection(long connectionId, Broker<?> broker, AmqpPort<?> port, Transport transport, AMQPConnection_0_10 serverProtocolEngine) {
        this._connectionId = connectionId;
        this._broker = broker;
        this._port = port;
        this._transport = transport;
        this._amqpConnection = serverProtocolEngine;
    }

    public Object getReference() {
        return this._reference;
    }

    public Broker<?> getBroker() {
        return this._broker;
    }

    protected void invoke(Method method) {
        super.invoke(method);
        if (method instanceof ConnectionClose) {
            this._ignoreAllButConnectionCloseOk = true;
        }
    }

    EventLogger getEventLogger() {
        return this._amqpConnection.getEventLogger();
    }

    protected void setState(Connection.State state) {
        super.setState(state);
        if (state == Connection.State.CLOSING) {
            this.getAmqpConnection().getAggregateTicker().addTicker((Ticker)new ConnectionClosingTicker(System.currentTimeMillis() + 10000L, (ServerNetworkConnection)this.getNetworkConnection()));
            this.notifyWork();
        }
    }

    public ServerConnectionDelegate getConnectionDelegate() {
        return (ServerConnectionDelegate)super.getConnectionDelegate();
    }

    public AMQPConnection_0_10 getAmqpConnection() {
        return this._amqpConnection;
    }

    public NamedAddressSpace getAddressSpace() {
        return this._amqpConnection.getAddressSpace();
    }

    public void setVirtualHost(NamedAddressSpace addressSpace) {
        this._amqpConnection.setAddressSpace(addressSpace);
    }

    public AmqpPort<?> getPort() {
        return this._port;
    }

    public Transport getTransport() {
        return this._transport;
    }

    public void closeSessionAsync(final ServerSession session, final AMQConstant cause, final String message) {
        this.addAsyncTask(new Action<ServerConnection>(){

            public void performAction(ServerConnection conn) {
                if (!session.isClosing()) {
                    ExecutionException ex = new ExecutionException();
                    ExecutionErrorCode code = ExecutionErrorCode.INTERNAL_ERROR;
                    try {
                        code = ExecutionErrorCode.get((int)cause.getCode());
                    }
                    catch (IllegalArgumentException iae) {
                        // empty catch block
                    }
                    ex.setErrorCode(code);
                    ex.setDescription(message);
                    session.invoke((Method)ex);
                    session.close(cause, message);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(Throwable t) {
        try {
            super.exception(t);
        }
        finally {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof ServerScopedRuntimeException) {
                throw (ServerScopedRuntimeException)t;
            }
        }
    }

    public void received(final ProtocolEvent event) {
        ServerSession channel;
        this._lastIoTime.set(System.currentTimeMillis());
        AccessControlContext context = event.isConnectionControl() ? this._amqpConnection.getAccessControllerContext() : ((channel = (ServerSession)this.getSession(event.getChannel())) != null ? channel.getAccessControllerContext() : this._amqpConnection.getAccessControllerContext());
        if (!this._ignoreAllButConnectionCloseOk || event instanceof ConnectionCloseOk) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ServerConnection.super.received(event);
                    return null;
                }
            }, context);
        }
    }

    public void sendConnectionCloseAsync(final AMQConstant cause, final String message) {
        this.addAsyncTask(new Action<ServerConnection>(){

            public void performAction(ServerConnection object) {
                if (!ServerConnection.this.isClosing()) {
                    ServerConnection.this.markAllSessionsClosed();
                    ServerConnection.this.setState(Connection.State.CLOSING);
                    ConnectionCloseCode replyCode = ConnectionCloseCode.NORMAL;
                    try {
                        replyCode = ConnectionCloseCode.get((int)cause.getCode());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    ServerConnection.this.sendConnectionClose(replyCode, message, new Option[0]);
                }
            }
        });
    }

    protected void sendConnectionClose(ConnectionCloseCode replyCode, String replyText, Option ... _options) {
        super.sendConnectionClose(replyCode, replyText, _options);
    }

    protected void performDeleteTasks() {
        this._amqpConnection.performDeleteTasks();
    }

    public synchronized void block() {
        if (!this._blocking) {
            this._blocking = true;
            for (AMQSessionModel aMQSessionModel : this.getSessionModels()) {
                aMQSessionModel.block();
            }
        }
    }

    public synchronized void unblock() {
        if (this._blocking) {
            this._blocking = false;
            for (AMQSessionModel aMQSessionModel : this.getSessionModels()) {
                aMQSessionModel.unblock();
            }
        }
    }

    public synchronized void registerSession(Session ssn) {
        super.registerSession(ssn);
        this._amqpConnection.sessionAdded((ServerSession)ssn);
        if (this._blocking) {
            ((ServerSession)ssn).block();
        }
    }

    public synchronized void removeSession(Session ssn) {
        this._amqpConnection.sessionRemoved((ServerSession)ssn);
        super.removeSession(ssn);
    }

    public Collection<? extends ServerSession> getSessionModels() {
        return Collections.unmodifiableCollection(this.getChannels());
    }

    protected Collection<ServerSession> getChannels() {
        return super.getChannels();
    }

    public Subject getAuthorizedSubject() {
        return this._amqpConnection.getSubject();
    }

    public void setAuthorizedSubject(Subject authorizedSubject) {
        this._amqpConnection.setSubject(authorizedSubject);
    }

    public Principal getAuthorizedPrincipal() {
        return this._amqpConnection.getAuthorizedPrincipal();
    }

    public long getConnectionId() {
        return this._connectionId;
    }

    public String getRemoteAddressString() {
        return String.valueOf(this.getRemoteSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        try {
            this.performDeleteTasks();
            super.closed();
        }
        finally {
            NamedAddressSpace addressSpace = this.getAddressSpace();
            if (addressSpace != null) {
                addressSpace.deregisterConnection((AMQPConnection)this._amqpConnection);
            }
        }
    }

    private void markAllSessionsClosed() {
        for (Session session : this.getChannels()) {
            ServerSession session2 = (ServerSession)session;
            ((ServerSession)session).setClose(true);
            session2.closed();
        }
    }

    public void receivedComplete() {
        for (Session session : this.getChannels()) {
            ((ServerSession)session).receivedComplete();
        }
    }

    public void send(ProtocolEvent event) {
        this._lastIoTime.set(System.currentTimeMillis());
        super.send(event);
    }

    public String getClientId() {
        return this.getConnectionDelegate().getClientId();
    }

    public String getRemoteContainerName() {
        return this.getConnectionDelegate().getClientId();
    }

    public String getClientVersion() {
        return this.getConnectionDelegate().getClientVersion();
    }

    public String getClientProduct() {
        return this.getConnectionDelegate().getClientProduct();
    }

    public long getSessionCountLimit() {
        return this.getChannelMax();
    }

    public Principal getPeerPrincipal() {
        return this.getNetworkConnection().getPeerPrincipal();
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        super.setRemoteAddress(remoteAddress);
    }

    public void setLocalAddress(SocketAddress localAddress) {
        super.setLocalAddress(localAddress);
    }

    public void doHeartBeat() {
        super.doHeartBeat();
    }

    private void addAsyncTask(Action<ServerConnection> action) {
        this._asyncTaskList.add(action);
        this.notifyWork();
    }

    public int getMessageCompressionThreshold() {
        return this._amqpConnection.getMessageCompressionThreshold();
    }

    public int getMaxMessageSize() {
        return (int)Math.min(this._amqpConnection.getMaxMessageSize(), Integer.MAX_VALUE);
    }

    public void transportStateChanged() {
        for (AMQSessionModel aMQSessionModel : this.getSessionModels()) {
            aMQSessionModel.transportStateChanged();
        }
    }

    public void notifyWork() {
        this._amqpConnection.notifyWork();
    }

    public Iterator<Runnable> processPendingIterator() {
        return new ProcessPendingIterator();
    }

    public void closeAndIgnoreFutureInput() {
        this._ignoreFutureInput = true;
        this.getSender().close();
    }

    public boolean isIgnoreFutureInput() {
        return this._ignoreFutureInput;
    }

    public boolean isConnectionLost() {
        return super.isConnectionLost();
    }

    private class ProcessPendingIterator
    implements Iterator<Runnable> {
        private final Collection<? extends ServerSession> _sessionsWithPending;
        private Iterator<? extends AMQSessionModel<?>> _sessionIterator;

        private ProcessPendingIterator() {
            this._sessionsWithPending = new ArrayList<ServerSession>(ServerConnection.this.getSessionModels());
            this._sessionIterator = this._sessionsWithPending.iterator();
        }

        @Override
        public boolean hasNext() {
            return !this._sessionsWithPending.isEmpty() || !ServerConnection.this._asyncTaskList.isEmpty();
        }

        @Override
        public Runnable next() {
            if (!this._sessionsWithPending.isEmpty()) {
                if (!this._sessionIterator.hasNext()) {
                    this._sessionIterator = this._sessionsWithPending.iterator();
                }
                final AMQSessionModel<?> session = this._sessionIterator.next();
                return new Runnable(){

                    @Override
                    public void run() {
                        if (!session.processPending()) {
                            ProcessPendingIterator.this._sessionIterator.remove();
                        }
                    }
                };
            }
            if (!ServerConnection.this._asyncTaskList.isEmpty()) {
                final Action asyncAction = (Action)ServerConnection.this._asyncTaskList.poll();
                return new Runnable(){

                    @Override
                    public void run() {
                        asyncAction.performAction((Object)ServerConnection.this);
                    }
                };
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

