/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.ReplyTo;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.typedmessage.TypedBytesContentReader;
import org.apache.qpid.typedmessage.TypedBytesFormatException;
import org.apache.qpid.util.GZIPUtils;

@PluggableService
public class MessageConverter_v0_10_to_Internal
implements MessageConverter<MessageTransferMessage, InternalMessage> {
    public Class<MessageTransferMessage> getInputClass() {
        return MessageTransferMessage.class;
    }

    public Class<InternalMessage> getOutputClass() {
        return InternalMessage.class;
    }

    public InternalMessage convert(MessageTransferMessage serverMessage, NamedAddressSpace addressSpace) {
        byte[] uncompressed;
        String mimeType = serverMessage.getMessageHeader().getMimeType();
        byte[] data = new byte[(int)serverMessage.getSize()];
        int total = 0;
        for (QpidByteBuffer b : serverMessage.getContent(0, (int)serverMessage.getSize())) {
            int len = b.remaining();
            b.get(data, total, len);
            b.dispose();
            total += len;
        }
        String encoding = serverMessage.getMessageHeader().getEncoding();
        if ("gzip".equals(encoding) && (uncompressed = GZIPUtils.uncompressBufferToArray((ByteBuffer)ByteBuffer.wrap(data))) != null) {
            data = uncompressed;
            encoding = null;
        }
        Object body = MessageConverter_v0_10_to_Internal.convertMessageBody(mimeType, data);
        MessageProperties messageProps = serverMessage.getHeader().getMessageProperties();
        DelegatingMessageHeader fixedHeader = new DelegatingMessageHeader(serverMessage.getMessageHeader(), messageProps == null ? null : messageProps.getReplyTo(), encoding);
        return InternalMessage.convert((long)serverMessage.getMessageNumber(), (boolean)serverMessage.isPersistent(), (AMQMessageHeader)fixedHeader, (Object)body);
    }

    private static Object convertMessageBody(String mimeType, byte[] data) {
        if ("text/plain".equals(mimeType) || "text/xml".equals(mimeType)) {
            String text = new String(data);
            return text;
        }
        if ("jms/map-message".equals(mimeType)) {
            TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            int entries = reader.readIntImpl();
            for (int i = 0; i < entries; ++i) {
                try {
                    String propName = reader.readStringImpl();
                    Object value = reader.readObject();
                    map.put(propName, value);
                    continue;
                }
                catch (EOFException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (TypedBytesFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return map;
        }
        if ("amqp/map".equals(mimeType)) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(ByteBuffer.wrap(data));
            Map map = decoder.readMap();
            return map;
        }
        if ("amqp/list".equals(mimeType)) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(ByteBuffer.wrap(data));
            return decoder.readList();
        }
        if ("jms/stream-message".equals(mimeType)) {
            TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
            ArrayList<Object> list = new ArrayList<Object>();
            while (reader.remaining() != 0) {
                try {
                    list.add(reader.readObject());
                }
                catch (TypedBytesFormatException e) {
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
                catch (EOFException e) {
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
            }
            return list;
        }
        return data;
    }

    public String getType() {
        return "v0-10 to Internal";
    }

    private static class DelegatingMessageHeader
    implements AMQMessageHeader {
        private final AMQMessageHeader _delegate;
        private final ReplyTo _replyTo;
        private final String _encoding;

        private DelegatingMessageHeader(AMQMessageHeader delegate, ReplyTo replyTo, String encoding) {
            this._delegate = delegate;
            this._replyTo = replyTo;
            this._encoding = encoding;
        }

        public String getCorrelationId() {
            return this._delegate.getCorrelationId();
        }

        public long getExpiration() {
            return this._delegate.getExpiration();
        }

        public String getUserId() {
            return this._delegate.getUserId();
        }

        public String getAppId() {
            return this._delegate.getAppId();
        }

        public String getMessageId() {
            return this._delegate.getMessageId();
        }

        public String getMimeType() {
            return this._delegate.getMimeType();
        }

        public String getEncoding() {
            return this._encoding;
        }

        public byte getPriority() {
            return this._delegate.getPriority();
        }

        public long getTimestamp() {
            return this._delegate.getTimestamp();
        }

        public long getNotValidBefore() {
            return this._delegate.getNotValidBefore();
        }

        public String getType() {
            return this._delegate.getType();
        }

        public String getReplyTo() {
            return this._replyTo == null ? null : (this._replyTo.getExchange() == null || this._replyTo.getExchange().equals("") ? this._replyTo.getRoutingKey() : (this._replyTo.getRoutingKey() == null || this._replyTo.getRoutingKey().equals("") ? this._replyTo.getExchange() : this._replyTo.getExchange() + "/" + this._replyTo.getRoutingKey()));
        }

        public Object getHeader(String name) {
            return this._delegate.getHeader(name);
        }

        public boolean containsHeaders(Set<String> names) {
            return this._delegate.containsHeaders(names);
        }

        public boolean containsHeader(String name) {
            return this._delegate.containsHeader(name);
        }

        public Collection<String> getHeaderNames() {
            return this._delegate.getHeaderNames();
        }
    }
}

