/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import org.apache.qpid.server.flow.AbstractFlowCreditManager;
import org.apache.qpid.server.protocol.v0_10.FlowCreditManager_0_10;
import org.apache.qpid.server.transport.ProtocolEngine;

public class CreditCreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager_0_10 {
    private final ProtocolEngine _protocolEngine;
    private volatile long _bytesCredit;
    private volatile long _messageCredit;

    public CreditCreditManager(long bytesCredit, long messageCredit, ProtocolEngine protocolEngine) {
        this._protocolEngine = protocolEngine;
        this._bytesCredit = bytesCredit;
        this._messageCredit = messageCredit;
        this.setSuspended(!this.hasCredit());
    }

    public synchronized void restoreCredit(long messageCredit, long bytesCredit) {
        this.setSuspended(!this.hasCredit());
    }

    @Override
    public synchronized void addCredit(long messageCredit, long bytesCredit) {
        if (this._messageCredit >= 0L && messageCredit > 0L) {
            this._messageCredit += messageCredit;
        }
        boolean notifyIncrease = false;
        if (this._bytesCredit >= 0L && bytesCredit > 0L) {
            notifyIncrease = this._messageCredit != 0L && bytesCredit > 0L;
            this._bytesCredit += bytesCredit;
        }
        if (!this.setSuspended(!this.hasCredit()) && notifyIncrease) {
            this.notifyIncreaseBytesCredit();
        }
    }

    @Override
    public synchronized void clearCredit() {
        this._bytesCredit = 0L;
        this._messageCredit = 0L;
        this.setSuspended(true);
    }

    public synchronized boolean hasCredit() {
        return this._bytesCredit != 0L && this._messageCredit != 0L && !this._protocolEngine.isTransportBlockedForWriting();
    }

    public synchronized boolean useCreditForMessage(long msgSize) {
        if (this._protocolEngine.isTransportBlockedForWriting()) {
            this.setSuspended(true);
            return false;
        }
        if (this._messageCredit >= 0L) {
            if (this._messageCredit > 0L) {
                if (this._bytesCredit < 0L) {
                    --this._messageCredit;
                    return true;
                }
                if (msgSize <= this._bytesCredit) {
                    --this._messageCredit;
                    this._bytesCredit -= msgSize;
                    return true;
                }
                return false;
            }
            this.setSuspended(true);
            return false;
        }
        if (this._bytesCredit >= 0L) {
            if (msgSize <= this._bytesCredit) {
                this._bytesCredit -= msgSize;
                return true;
            }
            return false;
        }
        return true;
    }
}

