/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.v0_10.ServerAssembler;
import org.apache.qpid.server.protocol.v0_10.ServerConnection;
import org.apache.qpid.server.protocol.v0_10.ServerConnectionDelegate;
import org.apache.qpid.server.protocol.v0_10.ServerDisassembler;
import org.apache.qpid.server.protocol.v0_10.ServerInputHandler;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.transport.AbstractAMQPConnection;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.network.NetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPConnection_0_10
extends AbstractAMQPConnection<AMQPConnection_0_10> {
    private static final Logger _logger = LoggerFactory.getLogger(AMQPConnection_0_10.class);
    private final ServerInputHandler _inputHandler;
    private final ServerConnection _connection;
    private volatile boolean _transportBlockedForWriting;
    private final AtomicBoolean _stateChanged = new AtomicBoolean();
    private final AtomicReference<Action<ProtocolEngine>> _workListener = new AtomicReference();
    private ServerDisassembler _disassembler;

    public AMQPConnection_0_10(Broker<?> broker, ServerNetworkConnection network, AmqpPort<?> port, Transport transport, long id, AggregateTicker aggregateTicker) {
        super(broker, network, port, transport, Protocol.AMQP_0_10, id, aggregateTicker);
        this._connection = new ServerConnection(id, broker, port, transport, this);
        SocketAddress address = network.getLocalAddress();
        String fqdn = null;
        if (address instanceof InetSocketAddress) {
            fqdn = ((InetSocketAddress)address).getHostName();
        }
        SubjectCreator subjectCreator = port.getAuthenticationProvider().getSubjectCreator(transport.isSecure());
        ServerConnectionDelegate connDelegate = new ServerConnectionDelegate(broker, fqdn, subjectCreator);
        this._connection.setConnectionDelegate((ConnectionDelegate)connDelegate);
        this._connection.setRemoteAddress(network.getRemoteAddress());
        this._connection.setLocalAddress(network.getLocalAddress());
        this._inputHandler = new ServerInputHandler(new ServerAssembler(this._connection));
        this._connection.addFrameSizeObserver(this._inputHandler);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AMQPConnection_0_10.this._connection.setNetworkConnection((NetworkConnection)AMQPConnection_0_10.this.getNetwork());
                AMQPConnection_0_10.this._disassembler = new ServerDisassembler(AMQPConnection_0_10.this.wrapSender(AMQPConnection_0_10.this.getNetwork().getSender()), 4096);
                AMQPConnection_0_10.this._connection.setSender(AMQPConnection_0_10.this._disassembler);
                AMQPConnection_0_10.this._connection.addFrameSizeObserver(AMQPConnection_0_10.this._disassembler);
                return null;
            }
        }, this.getAccessControllerContext());
    }

    private ByteBufferSender wrapSender(final ByteBufferSender sender) {
        return new ByteBufferSender(){

            public boolean isDirectBufferPreferred() {
                return sender.isDirectBufferPreferred();
            }

            public void send(QpidByteBuffer msg) {
                AMQPConnection_0_10.this.updateLastWriteTime();
                sender.send(msg);
            }

            public void flush() {
                sender.flush();
            }

            public void close() {
                sender.close();
            }
        };
    }

    public void received(final QpidByteBuffer buf) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AMQPConnection_0_10.this.updateLastReadTime();
                try {
                    AMQPConnection_0_10.this._inputHandler.received(buf);
                    AMQPConnection_0_10.this._connection.receivedComplete();
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
                catch (StoreException e) {
                    if (AMQPConnection_0_10.this.getAddressSpace().isActive()) {
                        throw new ServerScopedRuntimeException((Throwable)e);
                    }
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
                return null;
            }
        }, this.getAccessControllerContext());
    }

    public void encryptedTransport() {
    }

    public void writerIdle() {
        this._connection.doHeartBeat();
    }

    public void readerIdle() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AMQPConnection_0_10.this._connection.getEventLogger().message(ConnectionMessages.IDLE_CLOSE((String)("Current connection state: " + (Object)((Object)AMQPConnection_0_10.this._connection.getConnectionDelegate().getState())), (boolean)true));
                AMQPConnection_0_10.this.getNetwork().close();
                return null;
            }
        }, this.getAccessControllerContext());
    }

    public String getAddress() {
        return this.getNetwork().getRemoteAddress().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    AMQPConnection_0_10.this._inputHandler.closed();
                    if (AMQPConnection_0_10.this._disassembler != null) {
                        AMQPConnection_0_10.this._disassembler.closed();
                    }
                    return null;
                }
            }, this.getAccessControllerContext());
        }
        finally {
            this.markTransportClosed();
        }
    }

    public boolean isTransportBlockedForWriting() {
        return this._transportBlockedForWriting;
    }

    public void setTransportBlockedForWriting(boolean blocked) {
        if (this._transportBlockedForWriting != blocked) {
            this._transportBlockedForWriting = blocked;
            this._connection.transportStateChanged();
        }
    }

    public Iterator<Runnable> processPendingIterator() {
        if (this.isIOThread()) {
            return this._connection.processPendingIterator();
        }
        return Collections.emptyIterator();
    }

    public boolean hasWork() {
        return this._stateChanged.get();
    }

    public void notifyWork() {
        this._stateChanged.set(true);
        Action<ProtocolEngine> listener = this._workListener.get();
        if (listener != null) {
            listener.performAction((Object)this);
        }
    }

    public void clearWork() {
        this._stateChanged.set(false);
    }

    public void setWorkListener(Action<ProtocolEngine> listener) {
        this._workListener.set(listener);
    }

    public boolean hasSessionWithName(byte[] name) {
        return this._connection.hasSessionWithName(name);
    }

    public void sendConnectionCloseAsync(AMQConstant cause, String message) {
        this._connection.sendConnectionCloseAsync(cause, message);
    }

    public void closeSessionAsync(AMQSessionModel<?> session, AMQConstant cause, String message) {
        this._connection.closeSessionAsync((ServerSession)session, cause, message);
    }

    public void block() {
        this._connection.block();
    }

    public String getRemoteContainerName() {
        return this._connection.getRemoteContainerName();
    }

    public Collection<? extends AMQSessionModel<?>> getSessionModels() {
        return this._connection.getSessionModels();
    }

    public void unblock() {
        this._connection.unblock();
    }

    public long getSessionCountLimit() {
        return this._connection.getSessionCountLimit();
    }

    protected boolean isOrderlyClose() {
        return !this._connection.isConnectionLost();
    }

    public void initialiseHeartbeating(long writerDelay, long readerDelay) {
        super.initialiseHeartbeating(writerDelay, readerDelay);
    }
}

