/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZkUtils {
    private static final Logger log = LoggerFactory.getLogger(ZkUtils.class);

    public static boolean checkNodeAndWaitExpired(ZooKeeper zk, String path, long sessionTimeoutMs) throws KeeperException, InterruptedException {
        CountDownLatch prevNodeLatch = new CountDownLatch(1);
        Watcher zkPrevNodeWatcher = watchedEvent -> {
            if (Watcher.Event.EventType.NodeDeleted == watchedEvent.getType()) {
                prevNodeLatch.countDown();
            }
        };
        Stat stat = zk.exists(path, zkPrevNodeWatcher);
        if (stat != null) {
            if (stat.getEphemeralOwner() != zk.getSessionId()) {
                log.info("Previous znode : {} still exists, so waiting {} ms for znode deletion", (Object)path, (Object)sessionTimeoutMs);
                if (!prevNodeLatch.await(sessionTimeoutMs, TimeUnit.MILLISECONDS)) {
                    throw new KeeperException.NodeExistsException(path);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getParentForPath(String path) {
        if (path == null) {
            return null;
        }
        int length = path.length();
        if (length == 0 || length == 1 && path.charAt(0) == '/') {
            return null;
        }
        int partStartIndex = 0;
        char lastChar = path.charAt(0);
        String lastPart = "/";
        StringBuilder sb = new StringBuilder();
        int index = 1;
        while (index < length) {
            char c = path.charAt(index);
            if (lastChar != '/') {
                if (c == '/') {
                    lastPart = path.substring(partStartIndex, index);
                    partStartIndex = -1;
                }
            } else if (c != '/') {
                sb.append(lastPart);
                partStartIndex = partStartIndex == 0 ? index : index - 1;
            }
            lastChar = c;
            ++index;
        }
        String parentPath = sb.toString();
        return parentPath.length() == 0 ? null : parentPath;
    }
}

