/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.util.HashedWheelTimer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicyImpl;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.configuration.Configuration;
import org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkIsolatedBookieEnsemblePlacementPolicy
extends RackawareEnsemblePlacementPolicy
implements ZooKeeperCache.Deserializer<BookiesRackConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(ZkIsolatedBookieEnsemblePlacementPolicy.class);
    public static final String ISOLATION_BOOKIE_GROUPS = "isolationBookieGroups";
    public static final String SECONDARY_ISOLATION_BOOKIE_GROUPS = "secondaryIsolationBookieGroups";
    private ZooKeeperCache bookieMappingCache = null;
    private final List<String> primaryIsolationGroups = new ArrayList<String>();
    private final List<String> secondaryIsolationGroups = new ArrayList<String>();
    private final ObjectMapper jsonMapper = ObjectMapperFactory.create();

    public RackawareEnsemblePlacementPolicyImpl initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        String secondaryIsolationGroupsString;
        String isolationGroup;
        int n;
        int n2;
        String[] stringArray;
        String isolationGroupsString;
        if (conf.getProperty(ISOLATION_BOOKIE_GROUPS) != null && !(isolationGroupsString = this.castToString(conf.getProperty(ISOLATION_BOOKIE_GROUPS))).isEmpty()) {
            stringArray = isolationGroupsString.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                isolationGroup = stringArray[n];
                this.primaryIsolationGroups.add(isolationGroup);
                ++n;
            }
            this.bookieMappingCache = this.getAndSetZkCache((Configuration)conf);
        }
        if (conf.getProperty(SECONDARY_ISOLATION_BOOKIE_GROUPS) != null && !(secondaryIsolationGroupsString = this.castToString(conf.getProperty(SECONDARY_ISOLATION_BOOKIE_GROUPS))).isEmpty()) {
            stringArray = secondaryIsolationGroupsString.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                isolationGroup = stringArray[n];
                this.secondaryIsolationGroups.add(isolationGroup);
                ++n;
            }
        }
        return super.initialize(conf, optionalDnsResolver, timer, featureProvider, statsLogger, bookieAddressResolver);
    }

    private String castToString(Object obj) {
        if (obj instanceof List) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object o : (List)obj) {
                result.add((String)o);
            }
            return String.join((CharSequence)",", result);
        }
        return obj.toString();
    }

    private ZooKeeperCache getAndSetZkCache(Configuration conf) {
        ZooKeeperCache zkCache = null;
        if (conf.getProperty("zk_cache_instance") != null) {
            zkCache = (ZooKeeperCache)conf.getProperty("zk_cache_instance");
        } else if (conf instanceof ClientConfiguration) {
            int zkTimeout = ((ClientConfiguration)conf).getZkTimeout();
            String zkServers = ((ClientConfiguration)conf).getZkServers();
            try {
                ZooKeeperClient zkClient = ZooKeeperClient.newBuilder().connectString(zkServers).sessionTimeoutMs(zkTimeout).build();
                zkCache = new ZooKeeperCache("bookies-isolation", (ZooKeeper)zkClient, (int)TimeUnit.MILLISECONDS.toSeconds(zkTimeout)){};
                conf.addProperty("zk_cache_instance", (Object)zkCache);
            }
            catch (Exception e) {
                LOG.error("Error creating zookeeper client", (Throwable)e);
            }
        } else {
            LOG.error("No zk configurations available");
        }
        return zkCache;
    }

    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        Set<BookieId> blacklistedBookies = this.getBlacklistedBookies(ensembleSize);
        if (excludeBookies == null) {
            excludeBookies = new HashSet<BookieId>();
        }
        excludeBookies.addAll(blacklistedBookies);
        return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
    }

    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        Set<BookieId> blacklistedBookies = this.getBlacklistedBookies(ensembleSize);
        if (excludeBookies == null) {
            excludeBookies = new HashSet<BookieId>();
        }
        excludeBookies.addAll(blacklistedBookies);
        return super.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
    }

    private Set<BookieId> getBlacklistedBookies(int ensembleSize) {
        HashSet<BookieId> blacklistedBookies;
        block11: {
            blacklistedBookies = new HashSet<BookieId>();
            try {
                Map bookieGroup;
                if (this.bookieMappingCache == null) break block11;
                BookiesRackConfiguration allGroupsBookieMapping = this.bookieMappingCache.getData("/bookies", this).orElseThrow(() -> new KeeperException.NoNodeException("/bookies"));
                Set allBookies = allGroupsBookieMapping.keySet();
                int totalAvailableBookiesInPrimaryGroup = 0;
                for (String group : allBookies) {
                    Set bookiesInGroup = ((Map)allGroupsBookieMapping.get((Object)group)).keySet();
                    if (!this.primaryIsolationGroups.contains(group)) {
                        for (String bookieAddress : bookiesInGroup) {
                            blacklistedBookies.add(BookieId.parse((String)bookieAddress));
                        }
                        continue;
                    }
                    for (String groupBookie : bookiesInGroup) {
                        totalAvailableBookiesInPrimaryGroup += this.knownBookies.containsKey(BookieId.parse((String)groupBookie)) ? 1 : 0;
                    }
                }
                for (String group : this.primaryIsolationGroups) {
                    bookieGroup = (Map)allGroupsBookieMapping.get((Object)group);
                    if (bookieGroup == null || bookieGroup.isEmpty()) continue;
                    for (String bookieAddress : bookieGroup.keySet()) {
                        blacklistedBookies.remove(BookieId.parse((String)bookieAddress));
                    }
                }
                if (totalAvailableBookiesInPrimaryGroup < ensembleSize) {
                    LOG.info("Not found enough available-bookies from primary isolation group {} , checking secondary group", this.primaryIsolationGroups, this.secondaryIsolationGroups);
                    for (String group : this.secondaryIsolationGroups) {
                        bookieGroup = (Map)allGroupsBookieMapping.get((Object)group);
                        if (bookieGroup == null || bookieGroup.isEmpty()) continue;
                        for (String bookieAddress : bookieGroup.keySet()) {
                            blacklistedBookies.remove(BookieId.parse((String)bookieAddress));
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Error getting bookie isolation info from zk: {}", (Object)e.getMessage());
            }
        }
        return blacklistedBookies;
    }

    @Override
    public BookiesRackConfiguration deserialize(String key, byte[] content) throws Exception {
        LOG.info("Reloading the bookie isolation groups mapping cache.");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading the bookie mappings with bookie info data: {}", (Object)new String(content));
        }
        return (BookiesRackConfiguration)this.jsonMapper.readValue(content, BookiesRackConfiguration.class);
    }
}

