/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.internal.adapter;

import java.util.function.Supplier;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.reactive.client.internal.adapter.ReactiveConsumerAdapterFactory;
import org.apache.pulsar.reactive.client.internal.adapter.ReactiveProducerAdapterFactory;
import org.apache.pulsar.reactive.client.internal.adapter.ReactiveReaderAdapterFactory;

class ReactivePulsarResourceAdapter {
    private final Supplier<PulsarClient> pulsarClientSupplier;

    ReactivePulsarResourceAdapter(Supplier<PulsarClient> pulsarClientSupplier) {
        this.pulsarClientSupplier = ReactivePulsarResourceAdapter.cachedSupplier(pulsarClientSupplier);
    }

    private static <T> Supplier<T> cachedSupplier(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T cachedValue;

            @Override
            public synchronized T get() {
                if (this.cachedValue == null) {
                    this.cachedValue = supplier.get();
                }
                return this.cachedValue;
            }
        };
    }

    ReactiveProducerAdapterFactory producer() {
        return new ReactiveProducerAdapterFactory(this.pulsarClientSupplier);
    }

    ReactiveConsumerAdapterFactory consumer() {
        return new ReactiveConsumerAdapterFactory(this.pulsarClientSupplier);
    }

    ReactiveReaderAdapterFactory reader() {
        return new ReactiveReaderAdapterFactory(this.pulsarClientSupplier);
    }
}

