/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test.jsr286.event;

import java.io.Serializable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.StateAwareResponse;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.annotations.DefaultTestPhase;
import org.apache.pluto.testsuite.test.jsr286.event.BaseEventTest;

@DefaultTestPhase(value="EVENT_PHASE")
public class SimplePayloadEventTest
extends BaseEventTest {
    public static final String SIMPLE_VALUE_PAYLOAD = "SIMPLE_STRING_VALUE";
    public static final String SIMPLE_PAYLOAD_EVENT = "event-with-simple-value";

    protected void fireEvents(ActionRequest request, ActionResponse response) {
        response.setEvent(SIMPLE_PAYLOAD_EVENT, (Serializable)((Object)SIMPLE_VALUE_PAYLOAD));
    }

    public TestResult checkExpectedEventWasFired(EventRequest request, EventResponse response) {
        this.tally((StateAwareResponse)response);
        TestResult result = new TestResult();
        result.setSpecPLT("15.2.2");
        result.setDescription("Check to make sure the the event-with-simple-value event was fired.");
        Event event = request.getEvent();
        if (event == null) {
            throw new NullPointerException("No event was received!");
        }
        if (SIMPLE_PAYLOAD_EVENT.equals(event.getName())) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Expected event name to be 'event-with-simple-value' but it was actually '" + event.getName() + "'");
        }
        return result;
    }

    public TestResult checkEventPayloadIsCorrectClass(EventRequest request, EventResponse response) {
        this.tally((StateAwareResponse)response);
        TestResult result = new TestResult();
        result.setSpecPLT("15.2.2");
        result.setDescription("Check to make sure that payload is an instanceof " + String.class);
        Event event = request.getEvent();
        if (event == null) {
            throw new NullPointerException("No event received!");
        }
        Serializable value = event.getValue();
        if (value == null) {
            result.setReturnCode(1);
            result.setResultMessage("Expected event payload type to be '" + String.class.getName() + "' but it was null.");
        } else if (value instanceof String) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Expected event payload type to be '" + String.class.getName() + "' but it was actually '" + value.getClass().getName() + "'");
        }
        return result;
    }

    public TestResult checkEventPayloadIsCorrect(EventRequest request, EventResponse response) {
        this.tally((StateAwareResponse)response);
        TestResult result = new TestResult();
        result.setSpecPLT("15.2.2");
        result.setDescription("Check to make sure that the payload carries the proper state information from the event.");
        String value = (String)((Object)request.getEvent().getValue());
        if (!SIMPLE_VALUE_PAYLOAD.equals(value)) {
            result.setReturnCode(1);
            result.setResultMessage("Expected payload color to be SIMPLE_STRING_VALUE but it was " + value);
        } else {
            result.setReturnCode(2);
        }
        return result;
    }
}

