/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test.jsr286;

import java.io.IOException;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.ProcessEvent;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.pluto.testsuite.test.jsr286.event.ComposedObject;

public class TestCompanionPortlet
extends GenericPortlet {
    public static final String EVENT_INFO_PARAM = "eventInfoParameter";

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        String eventInfo = request.getParameter(EVENT_INFO_PARAM);
        request.setAttribute("eventInfo", (Object)eventInfo);
        this.getPortletContext().getRequestDispatcher("/jsp/TestCompanionPortlet.jsp").include(request, response);
    }

    @ProcessEvent(name="event-with-simple-value")
    public void processSimplePayload(EventRequest request, EventResponse response) throws PortletException, IOException {
        StringBuilder feedback = new StringBuilder();
        feedback.append("Simple Payload Event received.");
        if (!"SIMPLE_STRING_VALUE".equals(request.getEvent().getValue())) {
            feedback.append("  Payload DID NOT match expected value.");
        } else {
            feedback.append("  Payload matched expected value.");
        }
        response.setRenderParameter(EVENT_INFO_PARAM, feedback.toString());
    }

    @ProcessEvent(name="event-with-complex-value")
    public void processComplexPayload(EventRequest request, EventResponse response) throws PortletException, IOException {
        StringBuilder feedback = new StringBuilder();
        feedback.append("Complex Payload Event received.");
        boolean failed = false;
        ComposedObject value = (ComposedObject)request.getEvent().getValue();
        if (!"red".equals(value.getColor())) {
            feedback.append("  Color DID NOT match expected value.");
            failed = true;
        }
        if (!"1, 1".equals(value.getPoint())) {
            feedback.append("  Point DID NOT match expected value.");
            failed = true;
        }
        if (!failed) {
            feedback.append("  Payload matched expected values.");
        }
        response.setRenderParameter(EVENT_INFO_PARAM, feedback.toString());
    }
}

