/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTimeoutTest
extends AbstractReflectivePortletTest {
    private static final Logger LOG = LoggerFactory.getLogger(SessionTimeoutTest.class);
    private static final String MAX_INACTIVE_INTERVAL_SET = "maxInactiveIntervalSet";

    protected TestResult checkSessionInvalidated(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure portlet session is invalidated after the max inactive interval.");
        result.setSpecPLT("15.6");
        String maxInactiveIntervalSet = request.getParameter(MAX_INACTIVE_INTERVAL_SET);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieved render parameter: maxInactiveIntervalSet = " + maxInactiveIntervalSet);
        }
        if (Boolean.TRUE.toString().equals(maxInactiveIntervalSet)) {
            PortletSession session;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Max inactive interval is set to portlet session: portlet session should have expired (current time millis: " + System.currentTimeMillis() + ")...");
            }
            if ((session = request.getPortletSession(false)) == null) {
                result.setReturnCode(2);
            } else {
                result.setReturnCode(1);
                result.setResultMessage("PortletSession should have expired and have been invalidated, but is still available. Make sure that other portlets did not create a new portlet session.");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Max inactive interval is not set to portlet session: setting to 5 seconds (current time millis: " + System.currentTimeMillis() + ")...");
            }
            PortletSession session = request.getPortletSession(true);
            session.setMaxInactiveInterval(5);
            result.setReturnCode(0);
            result.setResultMessage("Click the provided link to validate test.");
        }
        return result;
    }
}

