/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.util.Enumeration;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestUtils;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceCommonTest
extends AbstractReflectivePortletTest {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceCommonTest.class);
    protected static final String BOGUS_KEY = "org.apache.pluto.testsuite.BOGUS_KEY";
    protected static final String READ_ONLY_PREF_NAME = "readonly";
    protected static final String NO_VALUE_PREF_NAME = "nameWithNoValue";
    protected static final String PREF_NAME = "dummyName";
    protected static final String PREF_VALUE = "dummyValue";
    protected static final String DEF_VALUE = "Default";
    protected static final String NEW_VALUE = "notTheOriginal";

    protected TestResult checkGetEmptyPreference(PortletRequest request) {
        return this.doCheckDefaultPreference(request, "nonexistence!");
    }

    protected TestResult checkGetNoValuePreference(PortletRequest request) {
        return this.doCheckDefaultPreference(request, NO_VALUE_PREF_NAME);
    }

    private TestResult doCheckDefaultPreference(PortletRequest request, String preferenceName) {
        TestResult result = new TestResult();
        result.setDescription("Ensure proper default is returned when a non-existing/value-undefined preference is requested.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        String value = preferences.getValue(preferenceName, DEF_VALUE);
        String[] values = preferences.getValues(preferenceName, new String[]{DEF_VALUE});
        if (DEF_VALUE.equals(value) && values != null && values.length == 1 && DEF_VALUE.equals(values[0])) {
            result.setReturnCode(2);
        } else if (!DEF_VALUE.equals(value)) {
            TestUtils.failOnAssertion((String)"preference value", (Object)value, (Object)DEF_VALUE, (TestResult)result);
        } else {
            TestUtils.failOnAssertion((String)"preference values", (String[])values, (String[])new String[]{DEF_VALUE}, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkGetPreferences(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that preferences defined in the deployment descriptor may be retrieved.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        String value = preferences.getValue(PREF_NAME, DEF_VALUE);
        if (value != null && value.equals(PREF_VALUE)) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"preference value", (Object)value, (Object)PREF_VALUE, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkSetPreferenceSingleValue(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure a single preference value can be set.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        try {
            preferences.setValue("TEST", "TEST_VALUE");
        }
        catch (ReadOnlyException ex) {
            TestUtils.failOnException((String)"Unable to set preference value.", (Throwable)ex, (TestResult)result);
            return result;
        }
        String value = preferences.getValue("TEST", DEF_VALUE);
        if (value != null && value.equals("TEST_VALUE")) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"preference value", (Object)value, (Object)"TEST_VALUE", (TestResult)result);
        }
        return result;
    }

    protected TestResult checkSetPreferenceMultiValues(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure multiple preference values can be set.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        try {
            preferences.setValues("TEST", new String[]{"ONE", "ANOTHER"});
        }
        catch (ReadOnlyException ex) {
            TestUtils.failOnException((String)"Unable to set preference values.", (Throwable)ex, (TestResult)result);
            return result;
        }
        String[] values = preferences.getValues("TEST", new String[]{DEF_VALUE});
        if (values != null && values.length == 2 && values[0].equals("ONE") && values[1].equals("ANOTHER")) {
            result.setReturnCode(2);
        } else if (values == null) {
            TestUtils.failOnAssertion((String)"preference values", (String[])values, (String[])new String[]{"ONE", "ANOTHER"}, (TestResult)result);
        } else if (values.length != 2) {
            TestUtils.failOnAssertion((String)"length of preference values", (Object)String.valueOf(values.length), (Object)String.valueOf(2), (TestResult)result);
        } else {
            TestUtils.failOnAssertion((String)"preference values", (String[])values, (String[])new String[]{"ONE", "ANOTHER"}, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkSetPreferenceNull(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure a preference value can be set to null.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        try {
            preferences.setValue("TEST", null);
        }
        catch (ReadOnlyException ex) {
            TestUtils.failOnException((String)"Unable to set preference value.", (Throwable)ex, (TestResult)result);
            return result;
        }
        String value = preferences.getValue("TEST", DEF_VALUE);
        if (null == value) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"preference value", (Object)value, null, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkSetPreferencesReturnsFirst(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure the first value set to a given preference is returned first by PortletPreferences.getValue().");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        try {
            preferences.setValues("TEST", new String[]{"FIRST", "SECOND"});
        }
        catch (ReadOnlyException ex) {
            TestUtils.failOnException((String)"Unable to set preference values.", (Throwable)ex, (TestResult)result);
            return result;
        }
        String value = preferences.getValue("TEST", DEF_VALUE);
        if (value != null && value.equals("FIRST")) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"preference value", (Object)value, (Object)"FIRST", (TestResult)result);
        }
        return result;
    }

    protected TestResult checkResetPreferenceToDefault(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure preferences are properly reset.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        boolean setOccured = false;
        boolean resetOccured = false;
        try {
            preferences.setValue(PREF_NAME, NEW_VALUE);
            String value = preferences.getValue(PREF_NAME, DEF_VALUE);
            if (NEW_VALUE.equals(value)) {
                setOccured = true;
            }
            preferences.reset(PREF_NAME);
            value = preferences.getValue(PREF_NAME, DEF_VALUE);
            if (PREF_VALUE.equals(value)) {
                resetOccured = true;
            }
        }
        catch (ReadOnlyException ex) {
            TestUtils.failOnException((String)"Unable to set preference value.", (Throwable)ex, (TestResult)result);
            return result;
        }
        if (setOccured && resetOccured) {
            result.setReturnCode(2);
        } else if (!setOccured) {
            result.setReturnCode(0);
            result.setResultMessage("A function upon which the reset test depends failed to execute as expected. Check the other test results in this test suite.");
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Preferences value was not successfully reset after store");
        }
        return result;
    }

    protected TestResult checkResetPreferenceWithoutDefault(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure preferences are properly reset (removed) when the default value is not defined.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        boolean setOccured = false;
        boolean resetOccured = false;
        try {
            preferences.setValue(BOGUS_KEY, NEW_VALUE);
            String value = preferences.getValue(BOGUS_KEY, DEF_VALUE);
            if (NEW_VALUE.equals(value)) {
                setOccured = true;
            }
            preferences.reset(BOGUS_KEY);
            value = preferences.getValue(BOGUS_KEY, DEF_VALUE);
            if (DEF_VALUE.equals(value)) {
                resetOccured = true;
            }
        }
        catch (ReadOnlyException ex) {
            TestUtils.failOnException((String)"Unable to set preference value.", (Throwable)ex, (TestResult)result);
            return result;
        }
        if (setOccured && resetOccured) {
            result.setReturnCode(2);
        } else if (!setOccured) {
            result.setReturnCode(0);
            result.setResultMessage("A function upon which the reset test depends failed to execute as expected. Check the other test results in this test suite.");
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Preferences value was not successfully reset after store.");
        }
        return result;
    }

    protected TestResult checkModifyReadOnlyPreferences(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that setValue() / setValues() / reset() methods throw ReadOnlyException when invoked on read-only preferences.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        if (!preferences.isReadOnly(READ_ONLY_PREF_NAME)) {
            result.setReturnCode(0);
            result.setResultMessage("Preference readonly is not a read-only preference. This may be due to misconfiuration.");
            return result;
        }
        boolean setValueOK = false;
        boolean setValuesOK = false;
        boolean resetOK = false;
        try {
            preferences.setValue(READ_ONLY_PREF_NAME, "written");
        }
        catch (ReadOnlyException ex) {
            setValueOK = true;
        }
        try {
            preferences.setValues(READ_ONLY_PREF_NAME, new String[]{"written"});
        }
        catch (ReadOnlyException ex) {
            setValuesOK = true;
        }
        try {
            preferences.reset(READ_ONLY_PREF_NAME);
        }
        catch (ReadOnlyException ex) {
            resetOK = true;
        }
        if (setValueOK && setValuesOK && resetOK) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            StringBuffer buffer = new StringBuffer();
            if (!setValueOK) {
                buffer.append("setValue(..), ");
            }
            if (!setValuesOK) {
                buffer.append("setValues(..), ");
            }
            if (!resetOK) {
                buffer.append("reset(..), ");
            }
            result.setResultMessage("Method(s) [" + buffer.toString() + "] invoked on read-only preference (" + READ_ONLY_PREF_NAME + ") without ReadOnlyException.");
        }
        return result;
    }

    protected TestResult checkGetPreferenceNames(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure returned enumeration is valid.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        Map prefMap = preferences.getMap();
        boolean hasAll = true;
        Enumeration en = preferences.getNames();
        while (en.hasMoreElements()) {
            if (prefMap.containsKey(en.nextElement())) continue;
            hasAll = false;
            break;
        }
        if (hasAll) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("At least one name is not found in the preference map.");
        }
        return result;
    }

    protected TestResult checkGetPreferenceMap(PortletRequest request) {
        TestResult result = this.checkGetPreferenceNames(request);
        result.setDescription("Ensure returned map is valid.");
        result.setSpecPLT("14.1");
        return result;
    }

    protected TestResult checkPreferenceValueNotModified(PortletRequest request) {
        String newValue;
        TestResult result = new TestResult();
        result.setDescription("Preferences values are not modified if the values in the returned preference Map are altered.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Original Preferences:");
            this.logPreferences(preferences);
        }
        Map prefMap = preferences.getMap();
        String[] values = (String[])prefMap.get(PREF_NAME);
        String originalValue = null;
        String modifiedValue = "Value modified in preferences map.";
        if (values != null && values.length == 1) {
            originalValue = values[0];
            values[0] = modifiedValue;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Modified Preferences:");
            this.logPreferences(preferences);
        }
        if ((newValue = preferences.getValue(PREF_NAME, DEF_VALUE)) != null && newValue.equals(originalValue)) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Preference value modified according to the preference map.");
        }
        return result;
    }

    protected void logPreferences(PortletPreferences preferences) {
        StringBuffer buffer = new StringBuffer();
        Map map = preferences.getMap();
        for (String key : map.keySet()) {
            String[] values = (String[])map.get(key);
            buffer.append(key).append("=");
            if (values != null) {
                buffer.append("{");
                for (int i = 0; i < values.length; ++i) {
                    buffer.append(values[i]);
                    if (i >= values.length - 1) continue;
                    buffer.append(",");
                }
                buffer.append("}");
            } else {
                buffer.append("NULL");
            }
            buffer.append(";");
        }
        LOG.debug("PortletPreferences: " + buffer.toString());
    }
}

