/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.util.Enumeration;
import java.util.Map;
import javax.portlet.ActionRequest;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestUtils;
import org.apache.pluto.testsuite.annotations.DefaultTestPhase;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;

@DefaultTestPhase(value="ACTION_PHASE")
public class ActionParameterTest
extends AbstractReflectivePortletTest {
    public static final String KEY = "org.apache.pluto.testsuite.PARAM_ACTION_KEY";
    public static final String VALUE = "org.apache.pluto.testsuite.ACTION_VALUE";

    protected TestResult checkGetActionParameter(ActionRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure parameters encoded in action URL are available in the action request.");
        String value = request.getParameter(KEY);
        if (value != null && value.equals(VALUE)) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"parameter", (Object)value, (Object)VALUE, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkGetActionParamerMap(ActionRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure parameters encoded in action URL are available in the action request parameter map.");
        Map parameterMap = request.getParameterMap();
        String[] values = (String[])parameterMap.get(KEY);
        if (values != null && values.length == 1 && VALUE.equals(values[0])) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"parameter values", (String[])values, (String[])new String[]{VALUE}, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkParameterNames(ActionRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure parameters encoded in action URL exists in the parameter name enumeration.");
        boolean hasParameterName = false;
        Enumeration en = request.getParameterNames();
        while (!hasParameterName && en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!KEY.equals(name)) continue;
            hasParameterName = true;
        }
        if (hasParameterName) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Parameter name org.apache.pluto.testsuite.PARAM_ACTION_KEY not found in parameter name enumeration.");
        }
        return result;
    }
}

