/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.headerresource;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.container.url.BasePortalURL;
import org.apache.jetspeed.request.RequestContext;

public class HeaderResourceLib {
    protected static final String EOL = "\r\n";
    private static final String MAILTO_URL_SCHEME = "mailto";
    private static final int MAILTO_URL_SCHEME_LEN = "mailto".length();

    public static int getHeaderTypeId(String headerType) {
        int headerTypeNumber = -1;
        if (headerType != null) {
            if (headerType.equals("script")) {
                headerTypeNumber = 2;
            } else if (headerType.equals("script-start")) {
                headerTypeNumber = 1;
            } else if (headerType.equals("script-tag")) {
                headerTypeNumber = 4;
            } else if (headerType.equals("script-end")) {
                headerTypeNumber = 3;
            } else if (headerType.equals("style")) {
                headerTypeNumber = 5;
            } else if (headerType.equals("link-tag")) {
                headerTypeNumber = 6;
            } else if (headerType.equals("base-tag")) {
                headerTypeNumber = 7;
            }
        }
        return headerTypeNumber;
    }

    public static String getHeaderType(Integer headerTypeId) {
        String headerType = null;
        if (headerTypeId != null) {
            int typeid = headerTypeId;
            if (typeid == 2) {
                headerType = "script";
            } else if (typeid == 1) {
                headerType = "script-start";
            } else if (typeid == 4) {
                headerType = "script-tag";
            } else if (typeid == 3) {
                headerType = "script-end";
            } else if (typeid == 5) {
                headerType = "style";
            } else if (typeid == 6) {
                headerType = "link-tag";
            } else if (typeid == 7) {
                headerType = "base-tag";
            }
        }
        return headerType;
    }

    public static String getPortalBaseUrl(RequestContext requestContext) {
        return HeaderResourceLib.getPortalBaseUrl(requestContext, null);
    }

    public static String getPortalBaseUrl(RequestContext requestContext, BasePortalURL baseUrlAccessOverride) {
        return HeaderResourceLib.getPortalBaseUrl(requestContext, baseUrlAccessOverride, false);
    }

    public static String getPortalBaseUrl(RequestContext requestContext, BasePortalURL baseUrlAccessOverride, boolean fullUrl) {
        HttpServletRequest request = requestContext.getRequest();
        StringBuffer baseurl = new StringBuffer();
        if (fullUrl || !requestContext.getPortalURL().isRelativeOnly()) {
            if (baseUrlAccessOverride == null) {
                baseurl.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort());
            } else {
                baseurl.append(baseUrlAccessOverride.getServerScheme()).append("://").append(baseUrlAccessOverride.getServerName()).append(":").append(baseUrlAccessOverride.getServerPort());
            }
        }
        baseurl.append(request.getContextPath());
        return baseurl.toString();
    }

    public static String getPortalUrl(String portalBaseUrl, RequestContext requestContext) {
        HttpServletRequest request = requestContext.getRequest();
        StringBuffer portalurl = new StringBuffer();
        return portalurl.append(portalBaseUrl).append(request.getServletPath()).toString();
    }

    public static String getPortalUrl(String portalBaseUrl, RequestContext requestContext, String servletPath) {
        HttpServletRequest request = requestContext.getRequest();
        StringBuffer portalurl = new StringBuffer();
        return portalurl.append(portalBaseUrl).append(servletPath == null ? request.getServletPath() : servletPath).toString();
    }

    public static String getPortalUrl(String relativePath, String portalUrl) {
        return HeaderResourceLib.getPortalUrl(relativePath, portalUrl, false, null);
    }

    public static String getPortalUrl(String relativePath, String portalUrl, boolean encode, RequestContext requestContext) {
        if (relativePath == null) {
            relativePath = "";
        }
        if (relativePath.indexOf("://") == -1 && relativePath.indexOf("mailto:") == -1) {
            StringBuffer path = new StringBuffer();
            String portalurl = path.append(portalUrl).append(relativePath).toString();
            if (encode && requestContext != null) {
                return requestContext.getResponse().encodeURL(portalurl);
            }
            return portalurl;
        }
        return relativePath;
    }

    public static String getPortalResourceUrl(String relativePath, String portalBaseUrl) {
        return HeaderResourceLib.getPortalResourceUrl(relativePath, portalBaseUrl, false, null);
    }

    public static String getPortalResourceUrl(String relativePath, String portalBaseUrl, boolean encode, RequestContext requestContext) {
        if (relativePath == null) {
            relativePath = "";
        }
        boolean isPathRelative = true;
        int colonPos = relativePath.indexOf(58);
        if (colonPos != -1) {
            int pathLen = relativePath.length();
            if (colonPos <= pathLen - 3 && relativePath.charAt(colonPos + 1) == '/' && relativePath.charAt(colonPos + 2) == '/') {
                isPathRelative = false;
            } else if (colonPos >= MAILTO_URL_SCHEME_LEN && relativePath.substring(colonPos - MAILTO_URL_SCHEME_LEN, colonPos).equals(MAILTO_URL_SCHEME)) {
                isPathRelative = false;
            }
        }
        if (isPathRelative) {
            StringBuffer path = new StringBuffer();
            String resourceurl = path.append(portalBaseUrl).append(relativePath.startsWith("/") ? "" : "/").append(relativePath).toString();
            if (encode && requestContext != null) {
                return requestContext.getResponse().encodeURL(resourceurl);
            }
            return resourceurl;
        }
        return relativePath;
    }

    public static StringBuffer makeJSONObject(Map objectMap, boolean whenEmptyReturnNewObject) {
        return HeaderResourceLib.makeJSONObject(null, new Map[]{objectMap}, whenEmptyReturnNewObject);
    }

    public static StringBuffer makeJSONObject(Map[] objectMaps, boolean whenEmptyReturnNewObject) {
        return HeaderResourceLib.makeJSONObject(null, objectMaps, whenEmptyReturnNewObject);
    }

    public static StringBuffer makeJSONObject(StringBuffer jsonBuffer, Map objectMap, boolean whenEmptyReturnNewObject) {
        return HeaderResourceLib.makeJSONObject(jsonBuffer, new Map[]{objectMap}, whenEmptyReturnNewObject);
    }

    public static StringBuffer makeJSONObject(StringBuffer jsonBuffer, Map[] objectMaps, boolean whenEmptyReturnNewObject) {
        int objMapsLen;
        if (jsonBuffer == null) {
            jsonBuffer = new StringBuffer();
        }
        int added = 0;
        int n = objMapsLen = objectMaps == null ? 0 : objectMaps.length;
        if (objMapsLen > 0) {
            for (int i = 0; i < objMapsLen; ++i) {
                Map objectMap = objectMaps[i];
                if (objectMap == null || objectMap.size() <= 0) continue;
                if (added == 0) {
                    jsonBuffer.append("{");
                }
                for (Map.Entry objEntry : objectMap.entrySet()) {
                    Object objKey = objEntry.getKey();
                    if (objKey == null) continue;
                    if (added > 0) {
                        jsonBuffer.append(", ");
                    }
                    jsonBuffer.append("\"").append(objKey.toString()).append("\":");
                    Object objVal = objEntry.getValue();
                    if (objVal == null) {
                        objVal = "";
                    }
                    jsonBuffer.append("\"").append(objVal.toString()).append("\"");
                    ++added;
                }
            }
        }
        if (added > 0) {
            jsonBuffer.append("}");
        } else if (whenEmptyReturnNewObject) {
            jsonBuffer.append("{}");
        } else {
            return null;
        }
        return jsonBuffer;
    }

    public static String makeJavascriptStatement(String statement, String indent, boolean addEOL) {
        StringBuffer statementOut = new StringBuffer();
        if (statement != null && (statement = statement.trim()).length() > 0) {
            if (indent != null) {
                statementOut.append(indent);
            }
            statementOut.append(statement);
            if (statement.charAt(statement.length() - 1) != ';') {
                statementOut.append(";");
            }
            if (addEOL) {
                statementOut.append(EOL);
            }
        }
        return statementOut.toString();
    }

    public static String makeJSONStringArray(Collection stringList) {
        return HeaderResourceLib.makeJSONStringArray(stringList, null);
    }

    public static String makeJSONStringArray(Collection stringList, List compiledUniqueValues) {
        if (stringList != null && stringList.size() > 0) {
            StringBuffer stringListContent = new StringBuffer();
            for (String value : stringList) {
                if (value == null || value.length() <= 0) continue;
                if (stringListContent.length() > 0) {
                    stringListContent.append(", ");
                } else {
                    stringListContent.append("[ ");
                }
                stringListContent.append("\"").append(value).append("\"");
                if (compiledUniqueValues == null || compiledUniqueValues.contains(value)) continue;
                compiledUniqueValues.add(value);
            }
            if (stringListContent.length() > 0) {
                stringListContent.append(" ]");
                return stringListContent.toString();
            }
        }
        return null;
    }

    public static String makeJSONInteger(Object source, boolean quote) {
        String sourceStr;
        String string = sourceStr = source == null ? (String)null : source.toString();
        if (sourceStr != null) {
            try {
                Integer.parseInt(sourceStr);
                if (quote) {
                    sourceStr = "\"" + sourceStr + "\"";
                }
            }
            catch (NumberFormatException nex) {
                sourceStr = null;
            }
        }
        return sourceStr;
    }

    public static String makeJSONBoolean(Object source) {
        String boolStr;
        String string = boolStr = source == null ? (String)null : source.toString();
        if (boolStr != null && !boolStr.equals("false") && !boolStr.equals("true")) {
            boolStr = null;
        }
        return boolStr;
    }
}

