/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndian;

public final class ExObjRefAtom
extends RecordAtom {
    private byte[] _header;
    private int exObjIdRef;

    public ExObjRefAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort((byte[])this._header, (int)0, (int)0);
        LittleEndian.putUShort((byte[])this._header, (int)2, (int)((int)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)4);
        this.exObjIdRef = 0;
    }

    protected ExObjRefAtom(byte[] source, int start, int len) {
        this._header = Arrays.copyOfRange(source, start, start + 8);
        this.exObjIdRef = (int)LittleEndian.getUInt((byte[])source, (int)(start + 8));
    }

    @Override
    public long getRecordType() {
        return RecordTypes.ExObjRefAtom.typeID;
    }

    public int getExObjIdRef() {
        return this.exObjIdRef;
    }

    public void setExObjIdRef(int id) {
        this.exObjIdRef = id;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        byte[] recdata = new byte[4];
        LittleEndian.putUInt((byte[])recdata, (int)0, (long)this.exObjIdRef);
        out.write(recdata);
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties((String)"exObjIdRef", this::getExObjIdRef);
    }
}

