/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.view.SVBorder;
import org.apache.poi.hssf.view.SVFractionalFormat;
import org.apache.poi.hssf.view.SVTableUtils;

public class SVTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected SVBorder cellBorder = new SVBorder();
    private HSSFWorkbook wb = null;
    private final CellFormatter cellFormatter = new CellFormatter();

    public SVTableCellRenderer(HSSFWorkbook wb) {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.wb = wb;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color back;
        boolean isBorderSet = false;
        HSSFCell c = (HSSFCell)value;
        if (c != null) {
            HSSFCellStyle s = c.getCellStyle();
            HSSFFont f = this.wb.getFontAt(s.getFontIndex());
            this.setFont(SVTableUtils.makeFont(f));
            if (s.getFillPattern() == 1) {
                this.setBackground(SVTableUtils.getAWTColor(s.getFillForegroundColor(), SVTableUtils.white));
            } else {
                this.setBackground(SVTableUtils.white);
            }
            this.setForeground(SVTableUtils.getAWTColor(f.getColor(), SVTableUtils.black));
            this.cellBorder.setBorder(SVTableUtils.getAWTColor(s.getTopBorderColor(), SVTableUtils.black), SVTableUtils.getAWTColor(s.getRightBorderColor(), SVTableUtils.black), SVTableUtils.getAWTColor(s.getBottomBorderColor(), SVTableUtils.black), SVTableUtils.getAWTColor(s.getLeftBorderColor(), SVTableUtils.black), s.getBorderTop(), s.getBorderRight(), s.getBorderBottom(), s.getBorderLeft(), hasFocus);
            this.setBorder(this.cellBorder);
            isBorderSet = true;
            switch (c.getCellType()) {
                case 3: {
                    this.setValue("");
                    break;
                }
                case 4: {
                    if (c.getBooleanCellValue()) {
                        this.setValue("true");
                        break;
                    }
                    this.setValue("false");
                    break;
                }
                case 0: {
                    short format = s.getDataFormat();
                    double numericValue = c.getNumericCellValue();
                    if (this.cellFormatter.useRedColor(format, numericValue)) {
                        this.setForeground(Color.red);
                    } else {
                        this.setForeground(null);
                    }
                    this.setValue(this.cellFormatter.format(format, c.getNumericCellValue()));
                    break;
                }
                case 1: {
                    this.setValue(c.getRichStringCellValue().getString());
                    break;
                }
                default: {
                    this.setValue("?");
                }
            }
            switch (s.getAlignment()) {
                case 1: 
                case 4: 
                case 5: {
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 2: 
                case 6: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 0: 
                case 3: {
                    this.setHorizontalAlignment(4);
                    break;
                }
                default: {
                    this.setHorizontalAlignment(2);
                    break;
                }
            }
        } else {
            this.setValue("");
            this.setBackground(SVTableUtils.white);
        }
        if (hasFocus) {
            if (!isBorderSet) {
                this.cellBorder.setBorder(SVTableUtils.black, SVTableUtils.black, SVTableUtils.black, SVTableUtils.black, 0, 0, 0, 0, isSelected);
                this.setBorder(this.cellBorder);
            }
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else if (!isBorderSet) {
            this.setBorder(noFocusBorder);
        }
        boolean colorMatch = (back = this.getBackground()) != null && back.equals(table.getBackground()) && table.isOpaque();
        this.setOpaque(!colorMatch);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }

    private class CellFormatter {
        private Format[] textFormatter;
        private DecimalFormat generalNumberFormat = new DecimalFormat("0");

        public CellFormatter() {
            this.textFormatter = new Format[49];
            this.textFormatter[1] = new DecimalFormat("0");
            this.textFormatter[2] = new DecimalFormat("0.00");
            this.textFormatter[3] = new DecimalFormat("#,##0");
            this.textFormatter[4] = new DecimalFormat("#,##0.00");
            this.textFormatter[5] = new DecimalFormat("$#,##0;$#,##0");
            this.textFormatter[6] = new DecimalFormat("$#,##0;$#,##0");
            this.textFormatter[7] = new DecimalFormat("$#,##0.00;$#,##0.00");
            this.textFormatter[8] = new DecimalFormat("$#,##0.00;$#,##0.00");
            this.textFormatter[9] = new DecimalFormat("0%");
            this.textFormatter[10] = new DecimalFormat("0.00%");
            this.textFormatter[11] = new DecimalFormat("0.00E0");
            this.textFormatter[12] = new SVFractionalFormat("# ?/?");
            this.textFormatter[13] = new SVFractionalFormat("# ??/??");
            this.textFormatter[14] = new SimpleDateFormat("M/d/yy");
            this.textFormatter[15] = new SimpleDateFormat("d-MMM-yy");
            this.textFormatter[16] = new SimpleDateFormat("d-MMM");
            this.textFormatter[17] = new SimpleDateFormat("MMM-yy");
            this.textFormatter[18] = new SimpleDateFormat("h:mm a");
            this.textFormatter[19] = new SimpleDateFormat("h:mm:ss a");
            this.textFormatter[20] = new SimpleDateFormat("h:mm");
            this.textFormatter[21] = new SimpleDateFormat("h:mm:ss");
            this.textFormatter[22] = new SimpleDateFormat("M/d/yy h:mm");
            this.textFormatter[38] = new DecimalFormat("#,##0;#,##0");
            this.textFormatter[39] = new DecimalFormat("#,##0.00;#,##0.00");
            this.textFormatter[40] = new DecimalFormat("#,##0.00;#,##0.00");
            this.textFormatter[45] = new SimpleDateFormat("mm:ss");
            this.textFormatter[47] = new SimpleDateFormat("mm:ss.0");
            this.textFormatter[48] = new DecimalFormat("##0.0E0");
        }

        public String format(short index, Object value) {
            if (index == 0) {
                return value.toString();
            }
            if (this.textFormatter[index] == null) {
                throw new RuntimeException("Sorry. I cant handle the format code :" + Integer.toHexString(index));
            }
            return this.textFormatter[index].format(value);
        }

        public String format(short index, double value) {
            if (index <= 0) {
                return this.generalNumberFormat.format(value);
            }
            if (this.textFormatter[index] == null) {
                throw new RuntimeException("Sorry. I cant handle the format code :" + Integer.toHexString(index));
            }
            if (this.textFormatter[index] instanceof DecimalFormat) {
                return ((DecimalFormat)this.textFormatter[index]).format(value);
            }
            if (this.textFormatter[index] instanceof SVFractionalFormat) {
                return ((SVFractionalFormat)this.textFormatter[index]).format(value);
            }
            throw new RuntimeException("Sorry. I cant handle a non decimal formatter for a decimal value :" + Integer.toHexString(index));
        }

        public boolean useRedColor(short index, double value) {
            return (index == 6 || index == 8 || index == 38 || index == 39) && value < 0.0;
        }
    }
}

