/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

public class PlcDATE
extends PlcSimpleValue<LocalDate> {
    public static PlcDATE of(Object value) {
        if (value instanceof LocalDate) {
            return new PlcDATE((LocalDate)value);
        }
        if (value instanceof Long) {
            return new PlcDATE(LocalDateTime.ofInstant(Instant.ofEpochSecond((Long)value), ZoneId.systemDefault()).toLocalDate());
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    public static PlcDATE ofSecondsSinceEpoch(long secondsSinceEpoch) {
        return new PlcDATE(LocalDateTime.ofInstant(Instant.ofEpochSecond(secondsSinceEpoch), ZoneId.systemDefault()).toLocalDate());
    }

    public static PlcDATE ofDaysSinceEpoch(int daysSinceEpoch) {
        return new PlcDATE(LocalDateTime.ofInstant(Instant.ofEpochSecond((long)daysSinceEpoch * 86400L), ZoneId.systemDefault()).toLocalDate());
    }

    public static PlcDATE ofDaysSinceSiemensEpoch(int daysSinceSiemensEpoch) {
        return PlcDATE.ofDaysSinceEpoch(daysSinceSiemensEpoch + 7305);
    }

    public PlcDATE(LocalDate value) {
        super(value, true);
    }

    public PlcDATE(int daysSinceEpoch) {
        super(LocalDateTime.ofInstant(Instant.ofEpochSecond((long)daysSinceEpoch * 86400L), ZoneId.systemDefault()).toLocalDate(), true);
    }

    public PlcDATE(long secondsSinceEpoch) {
        super(LocalDateTime.ofInstant(Instant.ofEpochSecond(secondsSinceEpoch), ZoneId.systemDefault()).toLocalDate(), true);
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.DATE;
    }

    public long getSecondsSinceEpoch() {
        return ((LocalDate)this.value).atStartOfDay(ZoneId.systemDefault()).toEpochSecond();
    }

    public int getDaysSinceEpoch() {
        return (int)(((LocalDate)this.value).atStartOfDay(ZoneId.systemDefault()).toEpochSecond() / 86400L);
    }

    public int getDaysSinceSiemensEpoch() {
        return (int)(((LocalDate)this.value).atStartOfDay(ZoneId.systemDefault()).toEpochSecond() / 86400L) - 7304;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        Instant instant = ((LocalDate)this.value).atStartOfDay(ZoneId.systemDefault()).toInstant();
        return instant.toEpochMilli() / 1000L;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return ((LocalDate)this.value).toString();
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public LocalDate getDate() {
        return (LocalDate)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalDate)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

