/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.ConfigurationParameterConverter;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.ParameterConverter;
import org.apache.plc4x.java.spi.configuration.annotations.Required;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.BooleanDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.DoubleDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.FloatDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.IntDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.StringDefaultValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFactory.class);

    public <T extends Configuration> T createConfiguration(Class<T> pClazz, String protocolCode, String transportCode, String transportConfig, String paramString) {
        Configuration instance;
        Map fields = Arrays.stream(FieldUtils.getAllFields(pClazz)).filter(field -> field.getAnnotation(ConfigurationParameter.class) != null).collect(Collectors.toMap(ConfigurationFactory::getConfigurationName, Function.identity()));
        List missingFieldNames = fields.values().stream().filter(field -> field.getAnnotation(Required.class) != null).map(ConfigurationFactory::getConfigurationName).collect(Collectors.toList());
        try {
            instance = (Configuration)pClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to Instantiate Configuration Class", e);
        }
        try {
            Map<String, List<String>> paramStringValues = ConfigurationFactory.splitQuery(paramString);
            paramStringValues = new HashMap<String, List<String>>(paramStringValues);
            List<String> previousValue = paramStringValues.put("protocolCode", List.of(protocolCode));
            if (previousValue != null) {
                LOGGER.warn("protocolCode with value {} overridden by", (Object)protocolCode);
            }
            if ((previousValue = paramStringValues.put("transportCode", List.of(transportCode))) != null) {
                LOGGER.warn("transportCode with value {} overridden by", (Object)transportCode);
            }
            if ((previousValue = paramStringValues.put("transportConfig", List.of(transportConfig))) != null) {
                LOGGER.warn("transportConfig with value {} overridden by", (Object)transportConfig);
            }
            for (Map.Entry entry : fields.entrySet()) {
                String configName = entry.getKey();
                Field field2 = (Field)fields.get(configName);
                if (paramStringValues.containsKey(configName)) {
                    String stringValue = paramStringValues.get(configName).get(0);
                    stringValue = URLDecoder.decode(stringValue, StandardCharsets.UTF_8);
                    FieldUtils.writeField((Object)instance, (String)field2.getName(), (Object)ConfigurationFactory.toFieldValue(field2, stringValue), (boolean)true);
                    missingFieldNames.remove(configName);
                    continue;
                }
                Object defaultValue = ConfigurationFactory.getDefaultValueFromAnnotation(field2);
                if (defaultValue == null) continue;
                FieldUtils.writeField((Object)instance, (String)field2.getName(), (Object)defaultValue, (boolean)true);
                missingFieldNames.remove(configName);
            }
            if (!missingFieldNames.isEmpty()) {
                throw new IllegalArgumentException("Missing required fields: " + missingFieldNames);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to access all fields from Configuration Class '" + pClazz.getSimpleName() + "'", e);
        }
        return (T)instance;
    }

    public static <T> T configure(Configuration configuration, T obj) {
        if (ClassUtils.isAssignable(obj.getClass(), HasConfiguration.class)) {
            Class configClass;
            ParameterizedType parameterizedType;
            Type configType;
            Optional<ParameterizedType> typeOptional = Arrays.stream(obj.getClass().getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(type -> type.getRawType().equals(HasConfiguration.class)).findAny();
            if (typeOptional.isPresent() && (configType = (parameterizedType = typeOptional.get()).getActualTypeArguments()[0]) instanceof Class && (configClass = (Class)configType).isAssignableFrom(configuration.getClass())) {
                try {
                    ((HasConfiguration)obj).setConfiguration(configuration);
                }
                catch (Throwable t) {
                    LOGGER.error("Error setting the configuration", t);
                    throw new PlcRuntimeException("Error setting the configuration", t);
                }
            }
        }
        return obj;
    }

    private static String getConfigurationName(Field field) {
        if (StringUtils.isBlank((CharSequence)field.getAnnotation(ConfigurationParameter.class).value())) {
            return field.getName();
        }
        return field.getAnnotation(ConfigurationParameter.class).value();
    }

    private static Object toFieldValue(Field field, String valueString) {
        if (field == null) {
            throw new IllegalArgumentException("Field not defined");
        }
        if (field.getAnnotation(ParameterConverter.class) != null) {
            Class<ConfigurationParameterConverter<?>> converterClass = field.getAnnotation(ParameterConverter.class).value();
            try {
                ConfigurationParameterConverter<?> converter = converterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (converter.getType().isAssignableFrom(field.getType())) {
                    return converter.convert(valueString);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Could not initialize parameter converter", e);
            }
            throw new IllegalArgumentException("Unsupported field type " + field.getType() + " for converter " + converterClass);
        }
        if (field.getType() == String.class) {
            return valueString;
        }
        if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            return Boolean.parseBoolean(valueString);
        }
        if (field.getType() == Byte.TYPE || field.getType() == Byte.class) {
            return Byte.parseByte(valueString);
        }
        if (field.getType() == Short.TYPE || field.getType() == Short.class) {
            return Short.parseShort(valueString);
        }
        if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
            return Integer.parseInt(valueString);
        }
        if (field.getType() == Long.TYPE || field.getType() == Long.class) {
            return Long.parseLong(valueString);
        }
        if (field.getType() == Float.TYPE || field.getType() == Float.class) {
            return Float.valueOf(Float.parseFloat(valueString));
        }
        if (field.getType() == Double.TYPE || field.getType() == Double.class) {
            return Double.parseDouble(valueString);
        }
        throw new IllegalArgumentException("Unsupported property type " + field.getType().getName());
    }

    private static Object getDefaultValueFromAnnotation(Field field) {
        IntDefaultValue intDefaultValue = field.getAnnotation(IntDefaultValue.class);
        if (intDefaultValue != null) {
            return intDefaultValue.value();
        }
        BooleanDefaultValue booleanDefaultValue = field.getAnnotation(BooleanDefaultValue.class);
        if (booleanDefaultValue != null) {
            return booleanDefaultValue.value();
        }
        FloatDefaultValue floatDefaultValue = field.getAnnotation(FloatDefaultValue.class);
        if (floatDefaultValue != null) {
            return Float.valueOf(floatDefaultValue.value());
        }
        DoubleDefaultValue doubleDefaultValue = field.getAnnotation(DoubleDefaultValue.class);
        if (doubleDefaultValue != null) {
            return doubleDefaultValue.value();
        }
        StringDefaultValue stringDefaultValue = field.getAnnotation(StringDefaultValue.class);
        if (stringDefaultValue != null) {
            return stringDefaultValue.value();
        }
        return null;
    }

    private static Map<String, List<String>> splitQuery(String paramString) {
        if (StringUtils.isBlank((CharSequence)paramString)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(paramString.split("&")).map(ConfigurationFactory::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private static AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String it) {
        int idx = it.indexOf(61);
        String key = idx > 0 ? it.substring(0, idx) : it;
        String value = idx > 0 && it.length() > idx + 1 ? it.substring(idx + 1) : null;
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
    }
}

