/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.base.protocol;

import java.time.Duration;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.base.field.ModbusExtendedRegister;
import org.apache.plc4x.java.modbus.base.field.ModbusField;
import org.apache.plc4x.java.modbus.base.field.ModbusFieldCoil;
import org.apache.plc4x.java.modbus.base.field.ModbusFieldDiscreteInput;
import org.apache.plc4x.java.modbus.base.field.ModbusFieldHoldingRegister;
import org.apache.plc4x.java.modbus.base.field.ModbusFieldInputRegister;
import org.apache.plc4x.java.modbus.readwrite.DataItem;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusADU;
import org.apache.plc4x.java.modbus.readwrite.ModbusDataType;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUError;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadCoilsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadCoilsResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadDiscreteInputsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadDiscreteInputsResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadFileRecordRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadFileRecordRequestItem;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadFileRecordResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadHoldingRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadHoldingRegistersResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadInputRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadInputRegistersResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteFileRecordRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteFileRecordRequestItem;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteMultipleCoilsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteMultipleHoldingRegistersRequest;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcList;

public abstract class ModbusProtocolLogic<T extends ModbusADU>
extends Plc4xProtocolBase<T> {
    protected final DriverType driverType;
    protected Duration requestTimeout;
    protected short unitIdentifier;
    protected RequestTransactionManager tm;
    protected final AtomicInteger transactionIdentifierGenerator = new AtomicInteger(1);
    protected static final int FC_EXTENDED_REGISTERS_GROUP_HEADER_LENGTH = 2;
    protected static final int FC_EXTENDED_REGISTERS_FILE_RECORD_LENGTH = 10000;

    public ModbusProtocolLogic(DriverType driverType) {
        this.driverType = driverType;
    }

    public void close(ConversationContext<T> context) {
    }

    protected void decode(ConversationContext<T> context, T msg) throws Exception {
        super.decode(context, msg);
    }

    protected PlcResponseCode getErrorCode(ModbusPDUError errorResponse) {
        switch (errorResponse.getExceptionCode()) {
            case ILLEGAL_FUNCTION: {
                return PlcResponseCode.UNSUPPORTED;
            }
            case ILLEGAL_DATA_ADDRESS: {
                return PlcResponseCode.INVALID_ADDRESS;
            }
            case ILLEGAL_DATA_VALUE: {
                return PlcResponseCode.INVALID_DATA;
            }
            case SLAVE_DEVICE_FAILURE: {
                return PlcResponseCode.REMOTE_ERROR;
            }
            case ACKNOWLEDGE: {
                return PlcResponseCode.OK;
            }
            case SLAVE_DEVICE_BUSY: {
                return PlcResponseCode.REMOTE_BUSY;
            }
            case NEGATIVE_ACKNOWLEDGE: {
                return PlcResponseCode.REMOTE_ERROR;
            }
            case MEMORY_PARITY_ERROR: {
                return PlcResponseCode.INTERNAL_ERROR;
            }
            case GATEWAY_PATH_UNAVAILABLE: {
                return PlcResponseCode.INTERNAL_ERROR;
            }
            case GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND: {
                return PlcResponseCode.REMOTE_ERROR;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    protected ModbusPDU getReadRequestPdu(PlcField field) {
        if (field instanceof ModbusFieldDiscreteInput) {
            ModbusFieldDiscreteInput discreteInput = (ModbusFieldDiscreteInput)field;
            return new ModbusPDUReadDiscreteInputsRequest(discreteInput.getAddress(), discreteInput.getNumberOfElements());
        }
        if (field instanceof ModbusFieldCoil) {
            ModbusFieldCoil coil = (ModbusFieldCoil)field;
            return new ModbusPDUReadCoilsRequest(coil.getAddress(), coil.getNumberOfElements());
        }
        if (field instanceof ModbusFieldInputRegister) {
            ModbusFieldInputRegister inputRegister = (ModbusFieldInputRegister)field;
            return new ModbusPDUReadInputRegistersRequest(inputRegister.getAddress(), Math.max(inputRegister.getLengthWords(), 1));
        }
        if (field instanceof ModbusFieldHoldingRegister) {
            ModbusFieldHoldingRegister holdingRegister = (ModbusFieldHoldingRegister)field;
            return new ModbusPDUReadHoldingRegistersRequest(holdingRegister.getAddress(), Math.max(holdingRegister.getLengthWords(), 1));
        }
        if (field instanceof ModbusExtendedRegister) {
            List<ModbusPDUReadFileRecordRequestItem> itemArray;
            ModbusExtendedRegister extendedRegister = (ModbusExtendedRegister)field;
            int group1Address = extendedRegister.getAddress() % 10000;
            int group2Address = 0;
            short group1FileNumber = (short)(Math.floor((float)extendedRegister.getAddress() / 10000.0f) + 1.0);
            if (group1Address + extendedRegister.getLengthWords() <= 10000) {
                int group1Quantity = extendedRegister.getLengthWords();
                ModbusPDUReadFileRecordRequestItem group1 = new ModbusPDUReadFileRecordRequestItem(6, group1FileNumber, group1Address, group1Quantity);
                itemArray = Collections.singletonList(group1);
            } else {
                int group1Quantity = 10000 - group1Address;
                int group2Quantity = extendedRegister.getLengthWords() - group1Quantity;
                short group2FileNumber = (short)(group1FileNumber + 1);
                ModbusPDUReadFileRecordRequestItem group1 = new ModbusPDUReadFileRecordRequestItem(6, group1FileNumber, group1Address, group1Quantity);
                ModbusPDUReadFileRecordRequestItem group2 = new ModbusPDUReadFileRecordRequestItem(6, group2FileNumber, group2Address, group2Quantity);
                itemArray = Arrays.asList(group1, group2);
            }
            return new ModbusPDUReadFileRecordRequest(itemArray);
        }
        throw new PlcRuntimeException("Unsupported read field type " + field.getClass().getName());
    }

    protected ModbusPDU getWriteRequestPdu(PlcField field, PlcValue plcValue) {
        if (field instanceof ModbusFieldCoil) {
            ModbusFieldCoil coil = (ModbusFieldCoil)field;
            ModbusPDUWriteMultipleCoilsRequest request = new ModbusPDUWriteMultipleCoilsRequest(coil.getAddress(), coil.getNumberOfElements(), this.fromPlcValue(field, plcValue));
            if (request.getQuantity() == coil.getNumberOfElements()) {
                return request;
            }
            throw new PlcRuntimeException("Number of requested bytes (" + request.getQuantity() + ") doesn't match number of requested addresses (" + coil.getNumberOfElements() + ")");
        }
        if (field instanceof ModbusFieldHoldingRegister) {
            ModbusFieldHoldingRegister holdingRegister = (ModbusFieldHoldingRegister)field;
            ModbusPDUWriteMultipleHoldingRegistersRequest request = new ModbusPDUWriteMultipleHoldingRegistersRequest(holdingRegister.getAddress(), holdingRegister.getLengthWords(), this.fromPlcValue(field, plcValue));
            if (request.getValue().length == holdingRegister.getLengthWords() * 2) {
                return request;
            }
            throw new PlcRuntimeException("Number of requested values (" + request.getValue().length / 2 + ") doesn't match number of requested addresses (" + holdingRegister.getLengthWords() + ")");
        }
        if (field instanceof ModbusExtendedRegister) {
            List<ModbusPDUWriteFileRecordRequestItem> itemArray;
            ModbusExtendedRegister extendedRegister = (ModbusExtendedRegister)field;
            int group1Address = extendedRegister.getAddress() % 10000;
            int group2Address = 0;
            short group1FileNumber = (short)(Math.floor((float)extendedRegister.getAddress() / 10000.0f) + 1.0);
            if (group1Address + extendedRegister.getLengthWords() <= 10000) {
                int group1Quantity = extendedRegister.getLengthWords();
                ModbusPDUWriteFileRecordRequestItem group1 = new ModbusPDUWriteFileRecordRequestItem(6, group1FileNumber, group1Address, this.fromPlcValue(field, plcValue));
                itemArray = Collections.singletonList(group1);
            } else {
                int group1Quantity = 10000 - group1Address;
                int group2Quantity = extendedRegister.getLengthWords() - group1Quantity;
                short group2FileNumber = (short)(group1FileNumber + 1);
                byte[] plcValue1 = ArrayUtils.subarray((byte[])this.fromPlcValue(field, plcValue), (int)0, (int)group1Quantity);
                byte[] plcValue2 = ArrayUtils.subarray((byte[])this.fromPlcValue(field, plcValue), (int)group1Quantity, (int)this.fromPlcValue(field, plcValue).length);
                ModbusPDUWriteFileRecordRequestItem group1 = new ModbusPDUWriteFileRecordRequestItem(6, group1FileNumber, group1Address, plcValue1);
                ModbusPDUWriteFileRecordRequestItem group2 = new ModbusPDUWriteFileRecordRequestItem(6, group2FileNumber, group2Address, plcValue2);
                itemArray = Arrays.asList(group1, group2);
            }
            return new ModbusPDUWriteFileRecordRequest(itemArray);
        }
        throw new PlcRuntimeException("Unsupported write field type " + field.getClass().getName());
    }

    protected PlcValue toPlcValue(ModbusPDU request, ModbusPDU response, ModbusDataType dataType) throws ParseException {
        short fieldDataTypeSize = dataType.getDataTypeSize();
        if (request instanceof ModbusPDUReadDiscreteInputsRequest) {
            if (!(response instanceof ModbusPDUReadDiscreteInputsResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadDiscreteInputsResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadDiscreteInputsRequest req = (ModbusPDUReadDiscreteInputsRequest)request;
            ModbusPDUReadDiscreteInputsResponse resp = (ModbusPDUReadDiscreteInputsResponse)response;
            return this.readCoilBooleanList(req.getQuantity(), resp.getValue());
        }
        if (request instanceof ModbusPDUReadCoilsRequest) {
            if (!(response instanceof ModbusPDUReadCoilsResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadCoilsResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadCoilsRequest req = (ModbusPDUReadCoilsRequest)request;
            ModbusPDUReadCoilsResponse resp = (ModbusPDUReadCoilsResponse)response;
            return this.readCoilBooleanList(req.getQuantity(), resp.getValue());
        }
        if (request instanceof ModbusPDUReadInputRegistersRequest) {
            if (!(response instanceof ModbusPDUReadInputRegistersResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadInputRegistersResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadInputRegistersRequest req = (ModbusPDUReadInputRegistersRequest)request;
            ModbusPDUReadInputRegistersResponse resp = (ModbusPDUReadInputRegistersResponse)response;
            ReadBufferByteBased io = new ReadBufferByteBased(resp.getValue());
            if (fieldDataTypeSize < 2) {
                io.readByte();
            }
            return DataItem.staticParse((ReadBuffer)io, dataType, Math.max(Math.round((float)req.getQuantity() / ((float)fieldDataTypeSize / 2.0f)), 1));
        }
        if (request instanceof ModbusPDUReadHoldingRegistersRequest) {
            if (!(response instanceof ModbusPDUReadHoldingRegistersResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadHoldingRegistersResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadHoldingRegistersRequest req = (ModbusPDUReadHoldingRegistersRequest)request;
            ModbusPDUReadHoldingRegistersResponse resp = (ModbusPDUReadHoldingRegistersResponse)response;
            ReadBufferByteBased io = new ReadBufferByteBased(resp.getValue());
            if (dataType != ModbusDataType.STRING && fieldDataTypeSize < 2) {
                io.readByte();
            }
            return DataItem.staticParse((ReadBuffer)io, dataType, Math.max(Math.round((float)req.getQuantity() / ((float)fieldDataTypeSize / 2.0f)), 1));
        }
        if (request instanceof ModbusPDUReadFileRecordRequest) {
            short dataLength;
            ReadBufferByteBased io;
            if (!(response instanceof ModbusPDUReadFileRecordResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadFileRecordResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadFileRecordRequest req = (ModbusPDUReadFileRecordRequest)request;
            ModbusPDUReadFileRecordResponse resp = (ModbusPDUReadFileRecordResponse)response;
            if (resp.getItems().size() == 2 && resp.getItems().size() == req.getItems().size()) {
                io = new ReadBufferByteBased(ArrayUtils.addAll((byte[])resp.getItems().get(0).getData(), (byte[])resp.getItems().get(1).getData()));
                dataLength = (short)(resp.getItems().get(0).getLengthInBytes() + resp.getItems().get(1).getLengthInBytes() - 4);
            } else if (resp.getItems().size() == 1 && resp.getItems().size() == req.getItems().size()) {
                io = new ReadBufferByteBased(resp.getItems().get(0).getData());
                dataLength = (short)(resp.getItems().get(0).getLengthInBytes() - 2);
            } else {
                throw new PlcRuntimeException("Unexpected number of groups in response. Expected " + req.getItems().size() + ", but got " + resp.getItems().size());
            }
            if (fieldDataTypeSize < 2) {
                io.readByte();
            }
            return DataItem.staticParse((ReadBuffer)io, dataType, Math.round(Math.max((float)dataLength / 2.0f, 1.0f) / Math.max((float)fieldDataTypeSize / 2.0f, 1.0f)));
        }
        return null;
    }

    protected byte[] fromPlcValue(PlcField field, PlcValue plcValue) {
        ModbusDataType fieldDataType = ((ModbusField)field).getDataType();
        try {
            if (plcValue instanceof PlcList) {
                WriteBufferByteBased writeBuffer = new WriteBufferByteBased(DataItem.getLengthInBytes(plcValue, fieldDataType, plcValue.getLength()));
                DataItem.staticSerialize((WriteBuffer)writeBuffer, plcValue, fieldDataType, plcValue.getLength(), ByteOrder.BIG_ENDIAN);
                byte[] data = writeBuffer.getData();
                if (((ModbusField)field).getDataType() == ModbusDataType.BOOL) {
                    byte[] bytes = new byte[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        bytes[i] = this.reverseBitsOfByte(data[i]);
                    }
                    return bytes;
                }
                return data;
            }
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased(DataItem.getLengthInBytes(plcValue, fieldDataType, plcValue.getLength()));
            DataItem.staticSerialize((WriteBuffer)writeBuffer, plcValue, fieldDataType, plcValue.getLength(), ByteOrder.BIG_ENDIAN);
            return writeBuffer.getData();
        }
        catch (SerializationException e) {
            throw new PlcRuntimeException("Unable to parse PlcValue :- " + (Object)((Object)e));
        }
    }

    protected byte reverseBitsOfByte(byte b) {
        BitSet bits = BitSet.valueOf(new byte[]{b});
        BitSet reverse = BitSet.valueOf(new byte[]{-1});
        for (int j = 0; j < 8; ++j) {
            reverse.set(j, bits.get(7 - j));
        }
        return Arrays.copyOf(reverse.toByteArray(), 1)[0];
    }

    protected PlcValue readCoilBooleanList(int count, byte[] data) throws ParseException {
        int i;
        ReadBufferByteBased io = new ReadBufferByteBased(data);
        if (count == 1) {
            io.readInt(7);
            return new PlcBOOL(io.readBit());
        }
        int numFullBytes = count / 8;
        int numBitsIncompleteByte = count - numFullBytes * 8;
        PlcValue[] values = new PlcValue[count];
        for (i = 0; i < numFullBytes; ++i) {
            values[i * 8 + 7] = new PlcBOOL(io.readBit());
            values[i * 8 + 6] = new PlcBOOL(io.readBit());
            values[i * 8 + 5] = new PlcBOOL(io.readBit());
            values[i * 8 + 4] = new PlcBOOL(io.readBit());
            values[i * 8 + 3] = new PlcBOOL(io.readBit());
            values[i * 8 + 2] = new PlcBOOL(io.readBit());
            values[i * 8 + 1] = new PlcBOOL(io.readBit());
            values[i * 8] = new PlcBOOL(io.readBit());
        }
        if (numBitsIncompleteByte > 0) {
            io.readInt(8 - numBitsIncompleteByte);
            for (i = 1; i <= numBitsIncompleteByte; ++i) {
                values[numFullBytes * 8 + (numBitsIncompleteByte - i)] = new PlcBOOL(io.readBit());
            }
        }
        return new PlcList(Arrays.asList(values));
    }
}

