/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.twitter.elephantbird.util.Protobufs;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.proto.ProtoSchemaConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.IncompatibleSchemaModificationException;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoWriteSupport<T extends MessageOrBuilder>
extends WriteSupport<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoWriteSupport.class);
    public static final String PB_CLASS_WRITE = "parquet.proto.writeClass";
    public static final String PB_SPECS_COMPLIANT_WRITE = "parquet.proto.writeSpecsCompliant";
    private boolean writeSpecsCompliant = false;
    private RecordConsumer recordConsumer;
    private Class<? extends Message> protoMessage;
    private Descriptors.Descriptor descriptor;
    private MessageWriter messageWriter;
    private Map<String, Map<String, Integer>> protoEnumBookKeeper = new HashMap<String, Map<String, Integer>>();

    public ProtoWriteSupport() {
    }

    public ProtoWriteSupport(Class<? extends Message> protobufClass) {
        this.protoMessage = protobufClass;
    }

    public ProtoWriteSupport(Descriptors.Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getName() {
        return "protobuf";
    }

    public static void setSchema(Configuration configuration, Class<? extends Message> protoClass) {
        configuration.setClass(PB_CLASS_WRITE, protoClass, Message.class);
    }

    public static void setWriteSpecsCompliant(Configuration configuration, boolean writeSpecsCompliant) {
        configuration.setBoolean(PB_SPECS_COMPLIANT_WRITE, writeSpecsCompliant);
    }

    public void write(T record) {
        this.recordConsumer.startMessage();
        try {
            this.messageWriter.writeTopLevelMessage(record);
        }
        catch (RuntimeException e) {
            Message m = record instanceof Message.Builder ? ((Message.Builder)record).build() : (Message)record;
            LOG.error("Cannot write message {}: {}", (Object)e.getMessage(), (Object)m);
            throw e;
        }
        this.recordConsumer.endMessage();
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        HashMap<String, String> extraMetaData = new HashMap<String, String>();
        if (this.descriptor == null) {
            if (this.protoMessage == null) {
                Class pbClass = configuration.getClass(PB_CLASS_WRITE, null, Message.class);
                if (pbClass != null) {
                    this.protoMessage = pbClass;
                } else {
                    String msg = "Protocol buffer class or descriptor not specified.";
                    String hint = " Please use method ProtoParquetOutputFormat.setProtobufClass(...) or other similar method.";
                    throw new BadConfigurationException(msg + hint);
                }
            }
            this.descriptor = Protobufs.getMessageDescriptor(this.protoMessage);
            extraMetaData.put("parquet.proto.class", this.protoMessage.getName());
        }
        this.writeSpecsCompliant = configuration.getBoolean(PB_SPECS_COMPLIANT_WRITE, this.writeSpecsCompliant);
        MessageType rootSchema = new ProtoSchemaConverter(configuration).convert(this.descriptor);
        this.validatedMapping(this.descriptor, (GroupType)rootSchema);
        this.messageWriter = new MessageWriter(this.descriptor, (GroupType)rootSchema);
        extraMetaData.put("parquet.proto.descriptor", this.descriptor.toProto().toString());
        extraMetaData.put(PB_SPECS_COMPLIANT_WRITE, String.valueOf(this.writeSpecsCompliant));
        return new WriteSupport.WriteContext(rootSchema, extraMetaData);
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        Map<String, String> protoMetadata = this.enumMetadata();
        return new WriteSupport.FinalizedWriteContext(protoMetadata);
    }

    private Map<String, String> enumMetadata() {
        HashMap<String, String> enumMetadata = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, Integer>> enumNameNumberMapping : this.protoEnumBookKeeper.entrySet()) {
            StringBuilder nameNumberPairs = new StringBuilder();
            if (enumNameNumberMapping.getValue().isEmpty()) {
                LOG.info("No enum is written for {}", (Object)enumNameNumberMapping.getKey());
            }
            int idx = 0;
            for (Map.Entry<String, Integer> nameNumberPair : enumNameNumberMapping.getValue().entrySet()) {
                nameNumberPairs.append(nameNumberPair.getKey()).append(":").append(nameNumberPair.getValue());
                if (++idx >= enumNameNumberMapping.getValue().size()) continue;
                nameNumberPairs.append(",");
            }
            enumMetadata.put("parquet.proto.enum." + enumNameNumberMapping.getKey(), nameNumberPairs.toString());
        }
        return enumMetadata;
    }

    private void validatedMapping(Descriptors.Descriptor descriptor, GroupType parquetSchema) {
        List allFields = descriptor.getFields();
        for (Descriptors.FieldDescriptor fieldDescriptor : allFields) {
            int parquetIndex;
            String fieldName = fieldDescriptor.getName();
            int fieldIndex = fieldDescriptor.getIndex();
            if (fieldIndex == (parquetIndex = parquetSchema.getFieldIndex(fieldName))) continue;
            String message = "FieldIndex mismatch name=" + fieldName + ": " + fieldIndex + " != " + parquetIndex;
            throw new IncompatibleSchemaModificationException(message);
        }
    }

    private FieldWriter unknownType(Descriptors.FieldDescriptor fieldDescriptor) {
        String exceptionMsg = "Unknown type with descriptor \"" + fieldDescriptor + "\" and type \"" + fieldDescriptor.getJavaType() + "\".";
        throw new InvalidRecordException(exceptionMsg);
    }

    class BinaryWriter
    extends FieldWriter {
        BinaryWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ByteString byteString = value instanceof ByteString ? (ByteString)value : (value instanceof Message ? ((Message)value).toByteString() : ByteString.copyFromUtf8((String)value.toString()));
            Binary binary = Binary.fromConstantByteArray((byte[])byteString.toByteArray());
            ProtoWriteSupport.this.recordConsumer.addBinary(binary);
        }
    }

    class BooleanWriter
    extends FieldWriter {
        BooleanWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.addBoolean(((Boolean)value).booleanValue());
        }
    }

    class EnumWriter
    extends FieldWriter {
        Map<String, Integer> enumNameNumberPairs;

        public EnumWriter(Descriptors.EnumDescriptor enumType) {
            if (ProtoWriteSupport.this.protoEnumBookKeeper.containsKey(enumType.getFullName())) {
                this.enumNameNumberPairs = (Map)ProtoWriteSupport.this.protoEnumBookKeeper.get(enumType.getFullName());
            } else {
                this.enumNameNumberPairs = new HashMap<String, Integer>();
                ProtoWriteSupport.this.protoEnumBookKeeper.put(enumType.getFullName(), this.enumNameNumberPairs);
            }
        }

        @Override
        final void writeRawValue(Object value) {
            Descriptors.EnumValueDescriptor enumValueDesc = (Descriptors.EnumValueDescriptor)value;
            Binary binary = Binary.fromString((String)enumValueDesc.getName());
            ProtoWriteSupport.this.recordConsumer.addBinary(binary);
            this.enumNameNumberPairs.putIfAbsent(enumValueDesc.getName(), enumValueDesc.getNumber());
        }
    }

    class DoubleWriter
    extends FieldWriter {
        DoubleWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.addDouble(((Double)value).doubleValue());
        }
    }

    class FloatWriter
    extends FieldWriter {
        FloatWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.addFloat(((Float)value).floatValue());
        }
    }

    class MapWriter
    extends FieldWriter {
        private final FieldWriter keyWriter;
        private final FieldWriter valueWriter;

        public MapWriter(FieldWriter keyWriter, FieldWriter valueWriter) {
            this.keyWriter = keyWriter;
            this.valueWriter = valueWriter;
        }

        @Override
        final void writeRawValue(Object value) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return;
            }
            ProtoWriteSupport.this.recordConsumer.startField(this.fieldName, this.index);
            ProtoWriteSupport.this.recordConsumer.startGroup();
            ProtoWriteSupport.this.recordConsumer.startField("key_value", 0);
            for (Message msg : collection) {
                ProtoWriteSupport.this.recordConsumer.startGroup();
                Descriptors.Descriptor descriptorForType = msg.getDescriptorForType();
                Descriptors.FieldDescriptor keyDesc = descriptorForType.findFieldByName("key");
                Descriptors.FieldDescriptor valueDesc = descriptorForType.findFieldByName("value");
                this.keyWriter.writeField(msg.getField(keyDesc));
                this.valueWriter.writeField(msg.getField(valueDesc));
                ProtoWriteSupport.this.recordConsumer.endGroup();
            }
            ProtoWriteSupport.this.recordConsumer.endField("key_value", 0);
            ProtoWriteSupport.this.recordConsumer.endGroup();
            ProtoWriteSupport.this.recordConsumer.endField(this.fieldName, this.index);
        }
    }

    class LongWriter
    extends FieldWriter {
        LongWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.addLong(((Long)value).longValue());
        }
    }

    class IntWriter
    extends FieldWriter {
        IntWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.addInteger(((Integer)value).intValue());
        }
    }

    class StringWriter
    extends FieldWriter {
        StringWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            Binary binaryString = Binary.fromString((String)((String)value));
            ProtoWriteSupport.this.recordConsumer.addBinary(binaryString);
        }
    }

    class RepeatedWriter
    extends FieldWriter {
        final FieldWriter fieldWriter;

        RepeatedWriter(FieldWriter fieldWriter) {
            this.fieldWriter = fieldWriter;
        }

        @Override
        final void writeRawValue(Object value) {
            throw new UnsupportedOperationException("Array has no raw value");
        }

        @Override
        final void writeField(Object value) {
            List list = (List)value;
            if (list.isEmpty()) {
                return;
            }
            ProtoWriteSupport.this.recordConsumer.startField(this.fieldName, this.index);
            for (Object listEntry : list) {
                this.fieldWriter.writeRawValue(listEntry);
            }
            ProtoWriteSupport.this.recordConsumer.endField(this.fieldName, this.index);
        }
    }

    class ArrayWriter
    extends FieldWriter {
        final FieldWriter fieldWriter;

        ArrayWriter(FieldWriter fieldWriter) {
            this.fieldWriter = fieldWriter;
        }

        @Override
        final void writeRawValue(Object value) {
            throw new UnsupportedOperationException("Array has no raw value");
        }

        @Override
        final void writeField(Object value) {
            List list = (List)value;
            if (list.isEmpty()) {
                return;
            }
            ProtoWriteSupport.this.recordConsumer.startField(this.fieldName, this.index);
            ProtoWriteSupport.this.recordConsumer.startGroup();
            ProtoWriteSupport.this.recordConsumer.startField("list", 0);
            for (Object listEntry : list) {
                ProtoWriteSupport.this.recordConsumer.startGroup();
                ProtoWriteSupport.this.recordConsumer.startField("element", 0);
                this.fieldWriter.writeRawValue(listEntry);
                ProtoWriteSupport.this.recordConsumer.endField("element", 0);
                ProtoWriteSupport.this.recordConsumer.endGroup();
            }
            ProtoWriteSupport.this.recordConsumer.endField("list", 0);
            ProtoWriteSupport.this.recordConsumer.endGroup();
            ProtoWriteSupport.this.recordConsumer.endField(this.fieldName, this.index);
        }
    }

    class MessageWriter
    extends FieldWriter {
        final FieldWriter[] fieldWriters;

        MessageWriter(Descriptors.Descriptor descriptor, GroupType schema) {
            List fields = descriptor.getFields();
            this.fieldWriters = (FieldWriter[])Array.newInstance(FieldWriter.class, fields.size());
            for (Descriptors.FieldDescriptor fieldDescriptor : fields) {
                String name = fieldDescriptor.getName();
                Type type = schema.getType(name);
                FieldWriter writer = this.createWriter(fieldDescriptor, type);
                if (ProtoWriteSupport.this.writeSpecsCompliant && fieldDescriptor.isRepeated() && !fieldDescriptor.isMapField()) {
                    writer = new ArrayWriter(writer);
                } else if (!ProtoWriteSupport.this.writeSpecsCompliant && fieldDescriptor.isRepeated()) {
                    writer = new RepeatedWriter(writer);
                }
                writer.setFieldName(name);
                writer.setIndex(schema.getFieldIndex(name));
                this.fieldWriters[fieldDescriptor.getIndex()] = writer;
            }
        }

        private FieldWriter createWriter(Descriptors.FieldDescriptor fieldDescriptor, Type type) {
            switch (fieldDescriptor.getJavaType()) {
                case STRING: {
                    return new StringWriter();
                }
                case MESSAGE: {
                    return this.createMessageWriter(fieldDescriptor, type);
                }
                case INT: {
                    return new IntWriter();
                }
                case LONG: {
                    return new LongWriter();
                }
                case FLOAT: {
                    return new FloatWriter();
                }
                case DOUBLE: {
                    return new DoubleWriter();
                }
                case ENUM: {
                    return new EnumWriter(fieldDescriptor.getEnumType());
                }
                case BOOLEAN: {
                    return new BooleanWriter();
                }
                case BYTE_STRING: {
                    return new BinaryWriter();
                }
            }
            return ProtoWriteSupport.this.unknownType(fieldDescriptor);
        }

        private FieldWriter createMessageWriter(Descriptors.FieldDescriptor fieldDescriptor, Type type) {
            if (fieldDescriptor.isMapField() && ProtoWriteSupport.this.writeSpecsCompliant) {
                return this.createMapWriter(fieldDescriptor, type);
            }
            if (type.isPrimitive() && type.asPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY) {
                return new BinaryWriter();
            }
            return new MessageWriter(fieldDescriptor.getMessageType(), this.getGroupType(type));
        }

        private GroupType getGroupType(final Type type) {
            LogicalTypeAnnotation logicalTypeAnnotation = type.getLogicalTypeAnnotation();
            if (logicalTypeAnnotation == null) {
                return type.asGroupType();
            }
            return logicalTypeAnnotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<GroupType>(){

                public Optional<GroupType> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
                    return Optional.ofNullable(type.asGroupType().getType("list").asGroupType().getType("element").asGroupType());
                }

                public Optional<GroupType> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
                    return Optional.ofNullable(type.asGroupType().getType("key_value").asGroupType().getType("value").asGroupType());
                }
            }).orElse(type.asGroupType());
        }

        private MapWriter createMapWriter(Descriptors.FieldDescriptor fieldDescriptor, Type type) {
            List fields = fieldDescriptor.getMessageType().getFields();
            if (fields.size() != 2) {
                throw new UnsupportedOperationException("Expected two fields for the map (key/value), but got: " + fields);
            }
            Descriptors.FieldDescriptor keyProtoField = (Descriptors.FieldDescriptor)fields.get(0);
            FieldWriter keyWriter = this.createWriter(keyProtoField, type);
            keyWriter.setFieldName(keyProtoField.getName());
            keyWriter.setIndex(0);
            Descriptors.FieldDescriptor valueProtoField = (Descriptors.FieldDescriptor)fields.get(1);
            FieldWriter valueWriter = this.createWriter(valueProtoField, type);
            valueWriter.setFieldName(valueProtoField.getName());
            valueWriter.setIndex(1);
            return new MapWriter(keyWriter, valueWriter);
        }

        void writeTopLevelMessage(Object value) {
            this.writeAllFields((MessageOrBuilder)value);
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.startGroup();
            this.writeAllFields((MessageOrBuilder)value);
            ProtoWriteSupport.this.recordConsumer.endGroup();
        }

        @Override
        final void writeField(Object value) {
            ProtoWriteSupport.this.recordConsumer.startField(this.fieldName, this.index);
            this.writeRawValue(value);
            ProtoWriteSupport.this.recordConsumer.endField(this.fieldName, this.index);
        }

        private void writeAllFields(MessageOrBuilder pb) {
            block4: {
                Descriptors.FileDescriptor.Syntax syntax;
                Descriptors.Descriptor messageDescriptor;
                block3: {
                    messageDescriptor = pb.getDescriptorForType();
                    syntax = messageDescriptor.getFile().getSyntax();
                    if (!Descriptors.FileDescriptor.Syntax.PROTO2.equals((Object)syntax)) break block3;
                    Map changedPbFields = pb.getAllFields();
                    for (Map.Entry entry : changedPbFields.entrySet()) {
                        Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)entry.getKey();
                        if (fieldDescriptor.isExtension()) {
                            throw new UnsupportedOperationException("Cannot convert Protobuf message with extension field(s)");
                        }
                        int fieldIndex = fieldDescriptor.getIndex();
                        this.fieldWriters[fieldIndex].writeField(entry.getValue());
                    }
                    break block4;
                }
                if (!Descriptors.FileDescriptor.Syntax.PROTO3.equals((Object)syntax)) break block4;
                List fieldDescriptors = messageDescriptor.getFields();
                for (Descriptors.FieldDescriptor fieldDescriptor : fieldDescriptors) {
                    Descriptors.FieldDescriptor.Type type = fieldDescriptor.getType();
                    if (fieldDescriptor.getContainingOneof() != null && !pb.hasField(fieldDescriptor) || !fieldDescriptor.isRepeated() && Descriptors.FieldDescriptor.Type.MESSAGE.equals((Object)type) && !pb.hasField(fieldDescriptor)) continue;
                    int fieldIndex = fieldDescriptor.getIndex();
                    FieldWriter fieldWriter = this.fieldWriters[fieldIndex];
                    fieldWriter.writeField(pb.getField(fieldDescriptor));
                }
            }
        }
    }

    class FieldWriter {
        String fieldName;
        int index = -1;

        FieldWriter() {
        }

        void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        void setIndex(int index) {
            this.index = index;
        }

        void writeRawValue(Object value) {
        }

        void writeField(Object value) {
            if (!(this instanceof MapWriter)) {
                ProtoWriteSupport.this.recordConsumer.startField(this.fieldName, this.index);
            }
            this.writeRawValue(value);
            if (!(this instanceof MapWriter)) {
                ProtoWriteSupport.this.recordConsumer.endField(this.fieldName, this.index);
            }
        }
    }
}

