/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.servlet;

import java.util.EventListener;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.web.util.ServletCompatibilityUtil;

public class WebBeansConfigurationListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansConfigurationListener.class);
    protected ContainerLifecycle lifeCycle;
    private WebBeansContext webBeansContext = WebBeansContext.getInstance();
    private ContextsService contextsService = this.webBeansContext.getContextsService();

    public void contextInitialized(ServletContextEvent event) {
        this.doStart(event);
    }

    public void requestInitialized(ServletRequestEvent event) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Starting a new request : [{0}]", event == null ? "null" : event.getServletRequest().getRemoteAddr());
            }
            this.lifeCycle.getContextService().startContext(RequestScoped.class, (Object)event);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0019", (Object[])new Object[]{event == null ? "null" : event.getServletRequest()}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Starting a session with session id : [{0}]", event.getSession().getId());
            }
            this.lifeCycle.getContextService().startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0020", (Object[])new Object[]{event.getSession()}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.lifeCycle != null) {
            this.lifeCycle.stopApplication((Object)event);
        }
        this.cleanupRequestThreadLocals();
    }

    public void requestDestroyed(ServletRequestEvent event) {
        ELContextStore elStore;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Destroying a request : [{0}]", event == null ? "null" : event.getServletRequest().getRemoteAddr());
        }
        if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
            elStore.destroyELContextStore();
        }
        this.lifeCycle.getContextService().endContext(RequestScoped.class, (Object)event);
        this.cleanupRequestThreadLocals();
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Destroying a session with session id : [{0}]", event.getSession().getId());
        }
        boolean mustDestroy = this.ensureRequestScope();
        this.lifeCycle.getContextService().endContext(SessionScoped.class, (Object)event.getSession());
        if (mustDestroy) {
            this.requestDestroyed(null);
        }
    }

    private void doStart(ServletContextEvent event) {
        if (event.getServletContext().getAttribute(this.getClass().getName()) != null) {
            return;
        }
        this.lifeCycle = (ContainerLifecycle)this.webBeansContext.getService(ContainerLifecycle.class);
        try {
            this.lifeCycle.startApplication((Object)event);
            event.getServletContext().setAttribute(this.getClass().getName(), (Object)true);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0018", (Object[])new Object[]{ServletCompatibilityUtil.getServletInfo(event.getServletContext())}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    private boolean ensureRequestScope() {
        Context context = this.lifeCycle.getContextService().getCurrentContext(RequestScoped.class);
        if (context == null || !context.isActive()) {
            this.requestInitialized(null);
            return true;
        }
        return false;
    }

    private void cleanupRequestThreadLocals() {
        if (this.contextsService != null) {
            this.contextsService.removeThreadLocals();
        }
    }

    public static class Auto
    implements ServletContainerInitializer {
        public void onStartup(Set<Class<?>> set, ServletContext servletContext) {
            String key = "openwebbeans.web.sci.active";
            if (!Boolean.parseBoolean(System.getProperty("openwebbeans.web.sci.active", servletContext.getInitParameter("openwebbeans.web.sci.active")))) {
                return;
            }
            WebBeansConfigurationListener listener = new WebBeansConfigurationListener();
            listener.doStart(new ServletContextEvent(servletContext));
            servletContext.addListener((EventListener)((Object)listener));
        }
    }
}

